
with Libsens.Common;                    use Libsens.Common;
with Libsens.Virtual;                   use Libsens.Virtual;
with Libsens.Virtual.Work_Class;        use Libsens.Virtual.Work_Class;
with Libsens.Processing.Plugins;        use Libsens.Processing.Plugins;

with Ada.Calendar;                      use Ada.Calendar;
package Libsens.Processing.Ctrl_Change is
   
   type Ctrl_Change_Processing(Plugin : Abstract_Plugin_Access);
   
   task type Ctrl_Change_Process (Ctrl_Change : access Ctrl_Change_Processing) is
      entry Initialize(Options : in Work_Options_Access);
      entry Start(Start_time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type);
      entry Stop;
      entry Halt;
   end Ctrl_Change_Process;
   
   type Ctrl_Change_Processing(Plugin : Abstract_Plugin_Access) is new Plugin_Processing(Cc_list) with
      record
	 Process : Ctrl_Change_Process(Ctrl_Change_Processing'Access);
      end record;
   
   
   procedure Initialize(Plugin_Process : in Ctrl_Change_Processing;Options : in Work_Options_Access);
   
   procedure Start(Plugin_Process : in Ctrl_Change_Processing;Start_Time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type);
   procedure Stop(Plugin_Process : in Ctrl_Change_Processing);
   procedure Halt(Plugin_Process : in Ctrl_Change_Processing);
end Libsens.Processing.Ctrl_Change;
