
with PragmARC.REM_NN_Wrapper;
use PragmARC.REM_NN_Wrapper;

----------------------------------------
-- Interface des réseaux de neurones. --
----------------------------------------

generic
   Width : Positive;
   
   Hidden : Natural;
   -- La largeur d'un réseau de neurones.
   -- Le nombe de sorties et d'entrées est égal. 
package Libsens.Neural_Network is
   
   
   type Samples_Type is array (Positive range <>) of Node_Set(1..Width);
   -- Fournit le tableau d'exemple à données pour l'apprentissage à la procédure Train.   
   
   
   procedure Train(Filename   : in String;
		   Samples    : in Samples_Type;
		   Reuse      : in Boolean;
		   Converged  : in Real;
		   Max_Epochs : in Positive);
   -- Entraine un réseau de neurones.
   -- "Filename"   : est le nom du fichier du réseau, le fichier sera crée ou écrasé à chaque exécution.
   -- "Samples"    : est l'ensemble d'exemples pour l'apprentissage.
   -- "Reuse"      : indique si la procédure doit réutiliser un fichier de réseau existant.
   -- "Converged"  : spécifit le point de convergence du réseau.
   -- "Max_Epochs" : indique le nombre d'apprentissage maximum effectués.
   
   function Respond(Filename   : in String;
		    Problem : in Node_Set) return Node_Set;
   -- Renvoie les sortie d'un réseau de neurone selon les entrées.
   -- "Filename" : est le nom du fichier du réseau, le fichier doit exister.
   -- Problem    : Les entrées du réseau.
   
   
   
   
end Libsens.Neural_Network;
