
with Glib;                              use Glib;

with Gtk.Label;                         use Gtk.Label;
with Gtk.Box;                           use Gtk.Box;
with Gtk.Paned;                         use Gtk.Paned;
with Gtk.Frame;                         use Gtk.Frame;
with Gtk.Tree_Model;                    use Gtk.Tree_Model;
with Gtk.Tree_View;                     use Gtk.Tree_View;
with Gtk.Tree_Store;                    use Gtk.Tree_Store;
with Gtk.Combo_Box_text;                use Gtk.Combo_Box_text;

with Libsens.Virtual;                   use Libsens.Virtual;

package Libsens.Gtk_Plugins_Specifications is
   
   type Abstract_Plugin_Specifications(Class : Plugin_Enum) is tagged
      record
	 Specifications_Frame : Gtk_Frame;
      end record;         
         
   type Plugin_Specifications_Access is
     access all Abstract_Plugin_Specifications'Class;
   
   type Plugin_Page_Type is tagged
      record
	 Plugin_Id            : Plugin_Num := 1;
	 Opened               : Boolean := False;
	 Page_Num             : Glib.Gint := (-1);
	 Page_Handler         : Gtk_Label;
	 Plugin_Frame         : Gtk_Frame;	 
	 Plugin_Paned         : Gtk_Hpaned;
	 
	 
	 Plugin_Spec          : Plugin_Specifications_Access;
	 
	 Options_Paned        : Gtk_Hpaned;
	 Details_Frame        : Gtk_Frame;
	 Details_Box            : Gtk_Vbox;
	 Timbre_Channel         :  Gtk_Combo_Box_Text;
	 Played_Form             : Gtk_Combo_Box_Text;
	 Timbre_Category         : Gtk_Combo_Box_Text;
	 Device_Id               : Gtk_Combo_Box_Text;
	 
	 
	 True_Table_Frame     : Gtk_Frame;
	 True_Table_Model        : Gtk_Tree_Store;
	 True_Table_Tree         : Gtk_Tree_View;
	 
	 Algo_Combo_box       : Gtk_Combo_Box_Text;
	 
	 Plugin_Hbox          : Gtk_Box;
      end record;
   
   
   
   
   Text_Column       : constant := 0;
   Editable_Column   : constant := 1;
   Active_Column     : constant := 2;
   Foreground_Column : constant := 3;
   Id_Column         : constant := 4;
   Type_Column       : constant := 5;
   Printable_Column  : constant := 6;
   Muttable_Column   : constant := 7;
   keys_Column       : constant := 1;
   MSB_Column        : constant := 1;
   Cname_Column      : constant := 1;
   CC_Column         : constant := 2;
   LSB_Column        : constant := 2;
   CV_Column         : constant := 3;
   Sens_Column       : constant := 2;
   Length_Column     : constant := 3;
   Prgm_Column       : constant := 3;
   bar_Column        : constant := 4;
   Number_Column     : constant := 8;
   step_Column       : constant := 9;   
   Transpose_Column  : constant := 10;
   Loop_Column       : constant := 11;
   

   
   
end Libsens.Gtk_Plugins_Specifications;
