

with Glib.Object;                       use Glib.Object;

with Gtk.Handlers;                      use Gtk.Handlers;
pragma Elaborate_All (Gtk.Handlers);
with Gtk.Widget;                        use Gtk.Widget;
with Gtk.Enums;                         use Gtk.Enums;
with Gtk.Frame;                         use Gtk.Frame;
with Gtk.Box;                           use Gtk.Box;
with Gtk.Label;                         use Gtk.Label;

with Libsens.Virtual.Nl_Network;        use Libsens.Virtual.NL_Network;

with Text_Io;                           use Text_Io;

package body Libsens.Gtk_Modulator is
   
   
  
   package Plugin_Cb is new Gtk.Handlers.User_Callback 
     (Gtk.Widget.Gtk_Widget_Record, 
      Abstract_Plugin_Access);
   
   procedure Reuse_Callback
     (Widget  : access Gtk_Widget_Record'Class;      
      Plugin : Abstract_Plugin_Access) is
   begin      
      
      Nl_Network_Plugin_Record(Plugin.all).Gen_Reuse := Boolean'Val(Gtk.Combo_Box_text.Get_Active(Gtk_Combo_Box_text(Widget)));
      
   exception
      when others =>
	 null;
   end Reuse_Callback;
   


   
   
   procedure Initialize (Spec : in out Modulator_Specifications;
     			 Plugin : in Abstract_Plugin_access) is
      

            
      Vbox : Gtk_Vbox;
      Label : Gtk_Label;
      Hbox : Gtk_Hbox;      
   begin
      
      
      
      Gtk_New(Spec.Specifications_Frame, "Modulator : ");
      
      Gtk_New_Vbox(Vbox, Homogeneous => False);
      
      
      
      Gtk_New(Spec.Reuse);
      Insert_Text(Spec.Reuse, 0, Boolean'Image(False));
      Insert_Text(Spec.Reuse, 1, Boolean'Image(True));                  
      Set_Active(Spec.Reuse, Boolean'Pos(Nl_Network_Plugin_Record(Plugin.all).Gen_Reuse));
      Gtk_New_Hbox(Hbox);
      Gtk_New(Label, "Reuse network   : ");      
      Pack_Start(Hbox, Label, False, False, 2);
      Pack_Start(Hbox, Spec.Reuse, False, False, 2);
      Pack_Start(Vbox, Hbox, False, False, 2);
      
      Plugin_Cb.Connect
        (Spec.Reuse, "changed", Plugin_Cb.To_Marshaller(Reuse_Callback'Access),
	 User_Data => Plugin);
      
      
      
      Add (Spec.Specifications_Frame, Vbox);      
      

      
      --Put_Line("Load seq 0.1.8.1");
      
   end Initialize;
   
   
   
   
end Libsens.Gtk_Modulator;
   
