with Libsens.Common;                    use Libsens.Common;


package Libsens.Data.BassDrum is
   
   subtype BassDrum_Value_type is Value_Type range 36..51;
   -- Normalement la note est indifférente.
	 
   subtype BassDrum_Sentence_Type is Sentence_type (BassDrum_Value_Type);
   
   Rime : constant Word16_Type := 16#1010#;
   Hat_Roll : constant Word16_Type := 16#5151#;
   
   function Tribe(Den : in Den_Type) return Word16_Type;            
   function Rand(Den : in Den_Type; Length : in Positive) return Word16_Type;
   
   
   task BassDrum_Gen is                  
      entry Respond(Filename: in String; Channel : in Channel_Type; Seq : in out Seq_Vectors.Vector);      
      entry Halt;
   end BassDrum_Gen;
   
end Libsens.Data.BassDrum;
