with Ada.Unchecked_Deallocation;
with Libsens.MIDI.Messages;             use Libsens.MIDI.Messages;
package Libsens.Common is
   
   type String_Access is access all String;
   procedure Free is new Ada.Unchecked_Deallocation(String, String_Access);
   
   
   Time_Unit_Max : constant Positive := 64;
   
   Time_Number_Max : constant Positive := 32;
   
   Time_Index_Max : constant Positive := Time_Unit_Max * Time_Number_Max;
   
   subtype Time_Index_Type is
     Positive range Positive'First .. Time_Index_Max;
   
   subtype Extended_Time_Index_Type is
     Natural range 0 .. Time_Index_Max;
   
   subtype Time_Unit_Type is
     Time_Index_Type range Time_Index_Type'First .. Time_Unit_Max;
   
   Unit_Default : constant Time_Unit_Type := Time_Unit_Type'Last / 4;
   
   subtype Time_Number_Type is
     Time_Index_Type range Time_Index_Type'First..Time_Number_Max;
   
   Number_Default : constant Time_Number_Type := Time_Number_Type'Last / 2;
   
   
   type Time_Signature_Type is
      record
	 Number   : Time_Number_Type;
	 Unit     : Time_Unit_Type;
      end record;
   
   function image(Signature : in Time_Signature_Type) return String;
   
   type Bar_Beat_Type is
     tagged record
      Bar         : Positive := Positive'First;
      Time_Number : Time_Number_Type := Time_Number_Type'First;
      Time_Unit   : Time_Unit_Type := Time_Unit_Type'First;
   end record;
   
   function Image(Bar_Beat : in Bar_Beat_Type) return String;
   
   procedure Next(Bar_Beat    : in out Bar_Beat_Type;
		  Bar         : in Natural;
		  Number      : in Time_Number_Type;
		  Unit        : in Time_Unit_Type);
   
   type Tempo_Type is delta 0.1 digits 4 range 1.0..240.0;
   
   
      subtype Den_Type is natural range 0..6;      
   
   subtype Step_Beat_Type is Positive range 1..2**6 + 1;
  
   subtype Numerator_Type is Positive range 1..32;    
   
   type Form_Type is (Minimal,  
		      HardTech, 
		      Acid,
		      Trance, Techno, Tribe, DnB,
		      HardCore);

   
   type Category_Type is (Null_Cat, Lead, Bass, Strings_N_Pads, Guitare_N_Pluck,
			  S_E, Synth_Hard, Synth_Soft,
			  Keyboard, Hit_N_Drum, Drums_Kit, Audio_In, Motion, Bell_N_Decay, User,
			  Arp_Seq, Vocoder, Split);
			  

   
   
   
   type T_Note is tagged
      record
         key : Value_Type := 64;
         Vel  : Value_Type := 64;
	 Len  : Value_Type := 8;
      end record;
   type Note_Access is access all T_Note;
   
   type T_Max_Chord_Length is range 1..2;
   type T_Chord is array (positive range <>) of Note_access;
   type Chord_Access is access all T_Chord;
   
   type T_Figure is (Quadruple, Triple, Double, Simple, Noire, Blanche, Ronde);
   function Bpm_To_Duration(Bpm : Tempo_Type;
                            figure : T_figure) return Duration;
   function To_Figure(Value : in Value_Type) return T_Figure;

   
   
   
end Libsens.Common;
