
with Libsens.Mal;                       use Libsens.Mal;
with Libsens.Common;                    use Libsens.Common;

with Libsens.MIDI.Messages;             use Libsens.MIDI.Messages;

package Libsens.Arch is

   use type Channel_Type;

   type Arche_Type(Form : Form_Type; Category : Category_Type) is abstract tagged
      record
	 Filename : access String;
      end record;
   type arche_access is access all arche_type'class;
   function Compose (Arche : in Arche_Type; Channel : in Channel_Type) return Seq_Vectors.Vector is abstract;

  type ACID_BASS_Type is new Arche_Type(Form => ACID, Category => BASS) with null record;
  type ACID_LEAD_Type is new Arche_Type(Form => ACID, Category => LEAD) with null record;
  type ACID_SYNTH_HARD_Type is new Arche_Type(Form => ACID, Category => SYNTH_HARD) with null record;
  type ACID_SYNTH_SOFT_Type is new Arche_Type(Form => ACID, Category => SYNTH_SOFT) with null record;
  type ACID_MOTION_Type is new Arche_Type(Form => ACID, Category => MOTION) with null record;
  type ACID_STRINGS_N_PADS_Type is new Arche_Type(Form => ACID, Category => STRINGS_N_PADS) with null record;
  type ACID_KEYBOARD_Type is new Arche_Type(Form => ACID, Category => KEYBOARD) with null record;
  type ACID_GUITARE_N_PLUCK_Type is new Arche_Type(Form => ACID, Category => GUITARE_N_PLUCK) with null record;
  type ACID_BELL_N_DECAY_Type is new Arche_Type(Form => ACID, Category => BELL_N_DECAY) with null record;
  type ACID_HIT_N_DRUM_Type is new Arche_Type(Form => ACID, Category => HIT_N_DRUM) with null record;
  type ACID_S_E_Type is new Arche_Type(Form => ACID, Category => S_E) with null record;
  type ACID_ARP_SEQ_Type is new Arche_Type(Form => ACID, Category => ARP_SEQ) with null record;
  type ACID_SPLIT_Type is new Arche_Type(Form => ACID, Category => SPLIT) with null record;
  type ACID_AUDIO_IN_Type is new Arche_Type(Form => ACID, Category => AUDIO_IN) with null record;
  type ACID_VOCODER_Type is new Arche_Type(Form => ACID, Category => VOCODER) with null record;
  type ACID_USER_Type is new Arche_Type(Form => ACID, Category => USER) with null record;
  type ACID_DRUMS_KIT_Type is new Arche_Type(Form => ACID, Category => DRUMS_KIT) with null record;
  type TECHNO_BASS_Type is new Arche_Type(Form => TECHNO, Category => BASS) with null record;
  type TECHNO_LEAD_Type is new Arche_Type(Form => TECHNO, Category => LEAD) with null record;
  type TECHNO_SYNTH_HARD_Type is new Arche_Type(Form => TECHNO, Category => SYNTH_HARD) with null record;
  type TECHNO_SYNTH_SOFT_Type is new Arche_Type(Form => TECHNO, Category => SYNTH_SOFT) with null record;
  type TECHNO_MOTION_Type is new Arche_Type(Form => TECHNO, Category => MOTION) with null record;
  type TECHNO_STRINGS_N_PADS_Type is new Arche_Type(Form => TECHNO, Category => STRINGS_N_PADS) with null record;
  type TECHNO_KEYBOARD_Type is new Arche_Type(Form => TECHNO, Category => KEYBOARD) with null record;
  type TECHNO_GUITARE_N_PLUCK_Type is new Arche_Type(Form => TECHNO, Category => GUITARE_N_PLUCK) with null record;
  type TECHNO_BELL_N_DECAY_Type is new Arche_Type(Form => TECHNO, Category => BELL_N_DECAY) with null record;
  type TECHNO_HIT_N_DRUM_Type is new Arche_Type(Form => TECHNO, Category => HIT_N_DRUM) with null record;
  type TECHNO_S_E_Type is new Arche_Type(Form => TECHNO, Category => S_E) with null record;
  type TECHNO_ARP_SEQ_Type is new Arche_Type(Form => TECHNO, Category => ARP_SEQ) with null record;
  type TECHNO_SPLIT_Type is new Arche_Type(Form => TECHNO, Category => SPLIT) with null record;
  type TECHNO_AUDIO_IN_Type is new Arche_Type(Form => TECHNO, Category => AUDIO_IN) with null record;
  type TECHNO_VOCODER_Type is new Arche_Type(Form => TECHNO, Category => VOCODER) with null record;
  type TECHNO_USER_Type is new Arche_Type(Form => TECHNO, Category => USER) with null record;
  type TECHNO_DRUMS_KIT_Type is new Arche_Type(Form => TECHNO, Category => DRUMS_KIT) with null record;
  type TRIBE_BASS_Type is new Arche_Type(Form => TRIBE, Category => BASS) with null record;
  type TRIBE_LEAD_Type is new Arche_Type(Form => TRIBE, Category => LEAD) with null record;
  type TRIBE_SYNTH_HARD_Type is new Arche_Type(Form => TRIBE, Category => SYNTH_HARD) with null record;
  type TRIBE_SYNTH_SOFT_Type is new Arche_Type(Form => TRIBE, Category => SYNTH_SOFT) with null record;
  type TRIBE_MOTION_Type is new Arche_Type(Form => TRIBE, Category => MOTION) with null record;
  type TRIBE_STRINGS_N_PADS_Type is new Arche_Type(Form => TRIBE, Category => STRINGS_N_PADS) with null record;
  type TRIBE_KEYBOARD_Type is new Arche_Type(Form => TRIBE, Category => KEYBOARD) with null record;
  type TRIBE_GUITARE_N_PLUCK_Type is new Arche_Type(Form => TRIBE, Category => GUITARE_N_PLUCK) with null record;
  type TRIBE_BELL_N_DECAY_Type is new Arche_Type(Form => TRIBE, Category => BELL_N_DECAY) with null record;
  type TRIBE_HIT_N_DRUM_Type is new Arche_Type(Form => TRIBE, Category => HIT_N_DRUM) with null record;
  type TRIBE_S_E_Type is new Arche_Type(Form => TRIBE, Category => S_E) with null record;
  type TRIBE_ARP_SEQ_Type is new Arche_Type(Form => TRIBE, Category => ARP_SEQ) with null record;
  type TRIBE_SPLIT_Type is new Arche_Type(Form => TRIBE, Category => SPLIT) with null record;
  type TRIBE_AUDIO_IN_Type is new Arche_Type(Form => TRIBE, Category => AUDIO_IN) with null record;
  type TRIBE_VOCODER_Type is new Arche_Type(Form => TRIBE, Category => VOCODER) with null record;
  type TRIBE_USER_Type is new Arche_Type(Form => TRIBE, Category => USER) with null record;
  type TRIBE_DRUMS_KIT_Type is new Arche_Type(Form => TRIBE, Category => DRUMS_KIT) with null record;
  type HARDTECH_BASS_Type is new Arche_Type(Form => HARDTECH, Category => BASS) with null record;
  type HARDTECH_LEAD_Type is new Arche_Type(Form => HARDTECH, Category => LEAD) with null record;
  type HARDTECH_SYNTH_HARD_Type is new Arche_Type(Form => HARDTECH, Category => SYNTH_HARD) with null record;
  type HARDTECH_SYNTH_SOFT_Type is new Arche_Type(Form => HARDTECH, Category => SYNTH_SOFT) with null record;
  type HARDTECH_MOTION_Type is new Arche_Type(Form => HARDTECH, Category => MOTION) with null record;
  type HARDTECH_STRINGS_N_PADS_Type is new Arche_Type(Form => HARDTECH, Category => STRINGS_N_PADS) with null record;
  type HARDTECH_KEYBOARD_Type is new Arche_Type(Form => HARDTECH, Category => KEYBOARD) with null record;
  type HARDTECH_GUITARE_N_PLUCK_Type is new Arche_Type(Form => HARDTECH, Category => GUITARE_N_PLUCK) with null record;
  type HARDTECH_BELL_N_DECAY_Type is new Arche_Type(Form => HARDTECH, Category => BELL_N_DECAY) with null record;
  type HARDTECH_HIT_N_DRUM_Type is new Arche_Type(Form => HARDTECH, Category => HIT_N_DRUM) with null record;
  type HARDTECH_S_E_Type is new Arche_Type(Form => HARDTECH, Category => S_E) with null record;
  type HARDTECH_ARP_SEQ_Type is new Arche_Type(Form => HARDTECH, Category => ARP_SEQ) with null record;
  type HARDTECH_SPLIT_Type is new Arche_Type(Form => HARDTECH, Category => SPLIT) with null record;
  type HARDTECH_AUDIO_IN_Type is new Arche_Type(Form => HARDTECH, Category => AUDIO_IN) with null record;
  type HARDTECH_VOCODER_Type is new Arche_Type(Form => HARDTECH, Category => VOCODER) with null record;
  type HARDTECH_USER_Type is new Arche_Type(Form => HARDTECH, Category => USER) with null record;
  type HARDTECH_DRUMS_KIT_Type is new Arche_Type(Form => HARDTECH, Category => DRUMS_KIT) with null record;
  type HARDCORE_BASS_Type is new Arche_Type(Form => HARDCORE, Category => BASS) with null record;
  type HARDCORE_LEAD_Type is new Arche_Type(Form => HARDCORE, Category => LEAD) with null record;
  type HARDCORE_SYNTH_HARD_Type is new Arche_Type(Form => HARDCORE, Category => SYNTH_HARD) with null record;
  type HARDCORE_SYNTH_SOFT_Type is new Arche_Type(Form => HARDCORE, Category => SYNTH_SOFT) with null record;
  type HARDCORE_MOTION_Type is new Arche_Type(Form => HARDCORE, Category => MOTION) with null record;
  type HARDCORE_STRINGS_N_PADS_Type is new Arche_Type(Form => HARDCORE, Category => STRINGS_N_PADS) with null record;
  type HARDCORE_KEYBOARD_Type is new Arche_Type(Form => HARDCORE, Category => KEYBOARD) with null record;
  type HARDCORE_GUITARE_N_PLUCK_Type is new Arche_Type(Form => HARDCORE, Category => GUITARE_N_PLUCK) with null record;
  type HARDCORE_BELL_N_DECAY_Type is new Arche_Type(Form => HARDCORE, Category => BELL_N_DECAY) with null record;
  type HARDCORE_HIT_N_DRUM_Type is new Arche_Type(Form => HARDCORE, Category => HIT_N_DRUM) with null record;
  type HARDCORE_S_E_Type is new Arche_Type(Form => HARDCORE, Category => S_E) with null record;
  type HARDCORE_ARP_SEQ_Type is new Arche_Type(Form => HARDCORE, Category => ARP_SEQ) with null record;
  type HARDCORE_SPLIT_Type is new Arche_Type(Form => HARDCORE, Category => SPLIT) with null record;
  type HARDCORE_AUDIO_IN_Type is new Arche_Type(Form => HARDCORE, Category => AUDIO_IN) with null record;
  type HARDCORE_VOCODER_Type is new Arche_Type(Form => HARDCORE, Category => VOCODER) with null record;
  type HARDCORE_USER_Type is new Arche_Type(Form => HARDCORE, Category => USER) with null record;
  type HARDCORE_DRUMS_KIT_Type is new Arche_Type(Form => HARDCORE, Category => DRUMS_KIT) with null record;
  type TRANCE_BASS_Type is new Arche_Type(Form => TRANCE, Category => BASS) with null record;
  type TRANCE_LEAD_Type is new Arche_Type(Form => TRANCE, Category => LEAD) with null record;
  type TRANCE_SYNTH_HARD_Type is new Arche_Type(Form => TRANCE, Category => SYNTH_HARD) with null record;
  type TRANCE_SYNTH_SOFT_Type is new Arche_Type(Form => TRANCE, Category => SYNTH_SOFT) with null record;
  type TRANCE_MOTION_Type is new Arche_Type(Form => TRANCE, Category => MOTION) with null record;
  type TRANCE_STRINGS_N_PADS_Type is new Arche_Type(Form => TRANCE, Category => STRINGS_N_PADS) with null record;
  type TRANCE_KEYBOARD_Type is new Arche_Type(Form => TRANCE, Category => KEYBOARD) with null record;
  type TRANCE_GUITARE_N_PLUCK_Type is new Arche_Type(Form => TRANCE, Category => GUITARE_N_PLUCK) with null record;
  type TRANCE_BELL_N_DECAY_Type is new Arche_Type(Form => TRANCE, Category => BELL_N_DECAY) with null record;
  type TRANCE_HIT_N_DRUM_Type is new Arche_Type(Form => TRANCE, Category => HIT_N_DRUM) with null record;
  type TRANCE_S_E_Type is new Arche_Type(Form => TRANCE, Category => S_E) with null record;
  type TRANCE_ARP_SEQ_Type is new Arche_Type(Form => TRANCE, Category => ARP_SEQ) with null record;
  type TRANCE_SPLIT_Type is new Arche_Type(Form => TRANCE, Category => SPLIT) with null record;
  type TRANCE_AUDIO_IN_Type is new Arche_Type(Form => TRANCE, Category => AUDIO_IN) with null record;
  type TRANCE_VOCODER_Type is new Arche_Type(Form => TRANCE, Category => VOCODER) with null record;
  type TRANCE_USER_Type is new Arche_Type(Form => TRANCE, Category => USER) with null record;
  type TRANCE_DRUMS_KIT_Type is new Arche_Type(Form => TRANCE, Category => DRUMS_KIT) with null record;
  type MINIMAL_BASS_Type is new Arche_Type(Form => MINIMAL, Category => BASS) with null record;
  type MINIMAL_LEAD_Type is new Arche_Type(Form => MINIMAL, Category => LEAD) with null record;
  type MINIMAL_SYNTH_HARD_Type is new Arche_Type(Form => MINIMAL, Category => SYNTH_HARD) with null record;
  type MINIMAL_SYNTH_SOFT_Type is new Arche_Type(Form => MINIMAL, Category => SYNTH_SOFT) with null record;
  type MINIMAL_MOTION_Type is new Arche_Type(Form => MINIMAL, Category => MOTION) with null record;
  type MINIMAL_STRINGS_N_PADS_Type is new Arche_Type(Form => MINIMAL, Category => STRINGS_N_PADS) with null record;
  type MINIMAL_KEYBOARD_Type is new Arche_Type(Form => MINIMAL, Category => KEYBOARD) with null record;
  type MINIMAL_GUITARE_N_PLUCK_Type is new Arche_Type(Form => MINIMAL, Category => GUITARE_N_PLUCK) with null record;
  type MINIMAL_BELL_N_DECAY_Type is new Arche_Type(Form => MINIMAL, Category => BELL_N_DECAY) with null record;
  type MINIMAL_HIT_N_DRUM_Type is new Arche_Type(Form => MINIMAL, Category => HIT_N_DRUM) with null record;
  type MINIMAL_S_E_Type is new Arche_Type(Form => MINIMAL, Category => S_E) with null record;
  type MINIMAL_ARP_SEQ_Type is new Arche_Type(Form => MINIMAL, Category => ARP_SEQ) with null record;
  type MINIMAL_SPLIT_Type is new Arche_Type(Form => MINIMAL, Category => SPLIT) with null record;
  type MINIMAL_AUDIO_IN_Type is new Arche_Type(Form => MINIMAL, Category => AUDIO_IN) with null record;
  type MINIMAL_VOCODER_Type is new Arche_Type(Form => MINIMAL, Category => VOCODER) with null record;
  type MINIMAL_USER_Type is new Arche_Type(Form => MINIMAL, Category => USER) with null record;
  type MINIMAL_DRUMS_KIT_Type is new Arche_Type(Form => MINIMAL, Category => DRUMS_KIT) with null record;
  type DNB_BASS_Type is new Arche_Type(Form => DNB, Category => BASS) with null record;
  type DNB_LEAD_Type is new Arche_Type(Form => DNB, Category => LEAD) with null record;
  type DNB_SYNTH_HARD_Type is new Arche_Type(Form => DNB, Category => SYNTH_HARD) with null record;
  type DNB_SYNTH_SOFT_Type is new Arche_Type(Form => DNB, Category => SYNTH_SOFT) with null record;
  type DNB_MOTION_Type is new Arche_Type(Form => DNB, Category => MOTION) with null record;
  type DNB_STRINGS_N_PADS_Type is new Arche_Type(Form => DNB, Category => STRINGS_N_PADS) with null record;
  type DNB_KEYBOARD_Type is new Arche_Type(Form => DNB, Category => KEYBOARD) with null record;
  type DNB_GUITARE_N_PLUCK_Type is new Arche_Type(Form => DNB, Category => GUITARE_N_PLUCK) with null record;
  type DNB_BELL_N_DECAY_Type is new Arche_Type(Form => DNB, Category => BELL_N_DECAY) with null record;
  type DNB_HIT_N_DRUM_Type is new Arche_Type(Form => DNB, Category => HIT_N_DRUM) with null record;
  type DNB_S_E_Type is new Arche_Type(Form => DNB, Category => S_E) with null record;
  type DNB_ARP_SEQ_Type is new Arche_Type(Form => DNB, Category => ARP_SEQ) with null record;
  type DNB_SPLIT_Type is new Arche_Type(Form => DNB, Category => SPLIT) with null record;
  type DNB_AUDIO_IN_Type is new Arche_Type(Form => DNB, Category => AUDIO_IN) with null record;
  type DNB_VOCODER_Type is new Arche_Type(Form => DNB, Category => VOCODER) with null record;
  type DNB_USER_Type is new Arche_Type(Form => DNB, Category => USER) with null record;
  type DNB_DRUMS_KIT_Type is new Arche_Type(Form => DNB, Category => DRUMS_KIT) with null record;


  function Compose (Arche : in ACID_BASS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_LEAD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_SYNTH_HARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_SYNTH_SOFT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_MOTION_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_STRINGS_N_PADS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_KEYBOARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_GUITARE_N_PLUCK_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_BELL_N_DECAY_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_HIT_N_DRUM_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_S_E_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_ARP_SEQ_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_SPLIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_AUDIO_IN_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_VOCODER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_USER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in ACID_DRUMS_KIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_BASS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_LEAD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_SYNTH_HARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_SYNTH_SOFT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_MOTION_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_STRINGS_N_PADS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_KEYBOARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_GUITARE_N_PLUCK_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_BELL_N_DECAY_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_HIT_N_DRUM_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_S_E_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_ARP_SEQ_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_SPLIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_AUDIO_IN_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_VOCODER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_USER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TECHNO_DRUMS_KIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_BASS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_LEAD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_SYNTH_HARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_SYNTH_SOFT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_MOTION_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_STRINGS_N_PADS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_KEYBOARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_GUITARE_N_PLUCK_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_BELL_N_DECAY_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_HIT_N_DRUM_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_S_E_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_ARP_SEQ_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_SPLIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_AUDIO_IN_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_VOCODER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_USER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRIBE_DRUMS_KIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_BASS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_LEAD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_SYNTH_HARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_SYNTH_SOFT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_MOTION_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_STRINGS_N_PADS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_KEYBOARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_GUITARE_N_PLUCK_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_BELL_N_DECAY_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_HIT_N_DRUM_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_S_E_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_ARP_SEQ_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_SPLIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_AUDIO_IN_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_VOCODER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_USER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDTECH_DRUMS_KIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_BASS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_LEAD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_SYNTH_HARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_SYNTH_SOFT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_MOTION_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_STRINGS_N_PADS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_KEYBOARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_GUITARE_N_PLUCK_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_BELL_N_DECAY_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_HIT_N_DRUM_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_S_E_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_ARP_SEQ_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_SPLIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_AUDIO_IN_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_VOCODER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_USER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in HARDCORE_DRUMS_KIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_BASS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_LEAD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_SYNTH_HARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_SYNTH_SOFT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_MOTION_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_STRINGS_N_PADS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_KEYBOARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_GUITARE_N_PLUCK_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_BELL_N_DECAY_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_HIT_N_DRUM_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_S_E_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_ARP_SEQ_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_SPLIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_AUDIO_IN_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_VOCODER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_USER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in TRANCE_DRUMS_KIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_BASS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_LEAD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_SYNTH_HARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_SYNTH_SOFT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_MOTION_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_STRINGS_N_PADS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_KEYBOARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_GUITARE_N_PLUCK_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_BELL_N_DECAY_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_HIT_N_DRUM_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_S_E_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_ARP_SEQ_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_SPLIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_AUDIO_IN_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_VOCODER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_USER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in MINIMAL_DRUMS_KIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_BASS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_LEAD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_SYNTH_HARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_SYNTH_SOFT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_MOTION_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_STRINGS_N_PADS_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_KEYBOARD_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_GUITARE_N_PLUCK_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_BELL_N_DECAY_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_HIT_N_DRUM_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_S_E_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_ARP_SEQ_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_SPLIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_AUDIO_IN_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_VOCODER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_USER_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;
  function Compose (Arche : in DNB_DRUMS_KIT_Type; Channel : in Channel_Type) return Seq_Vectors.Vector;


  procedure Finalize;

end Libsens.Arch;
