with Ada.Text_Io;
use Ada;

with Libsens.Data;

with Libsens.Data.Lead;
with Libsens.Data.Bass;
with Libsens.Data.Drums;
with Libsens.Data.Bassdrum;


use Libsens.Data;

with Text_Io;                           use Text_Io;

package body Libsens.Arch is
         
   
   
   procedure Finalize is
   begin
      
      Put_Line("Arch fibnalization.....");
      Libsens.Data.Lead.Lead_Gen.Halt;
      Put_Line("Lead gen halted...");
      Libsens.Data.Bass.Bass_Gen.Halt;
      Put_Line("Bass gen halted...");
      Libsens.Data.Drums.Drums_Gen.Halt;
      Put_Line("Drums gen halted...");
      Libsens.Data.Bassdrum.Bassdrum_Gen.Halt;
      Put_Line("Bassdrum gen halted...");
      Put_Line("Arch fibnalized !");
   end Finalize;
      
      
   ---------------------------------------------------------------------------
   --                                  Acid                                 --
   ---------------------------------------------------------------------------
   
   
   function Compose (Arche : in ACID_BASS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin            
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);            
      return Sequence;
   end Compose;
   function Compose (Arche : in ACID_LEAD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in ACID_SYNTH_HARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in ACID_SYNTH_SOFT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in ACID_MOTION_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in ACID_STRINGS_N_PADS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in ACID_KEYBOARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in ACID_GUITARE_N_PLUCK_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in ACID_BELL_N_DECAY_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in ACID_HIT_N_DRUM_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      --Put_Line("compose bassdrum...");
      Libsens.Data.Bassdrum.Bassdrum_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      --Put_Line("bassdrum composed.");
      return Sequence;
   end Compose;
   function Compose (Arche : in ACID_S_E_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in ACID_ARP_SEQ_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in ACID_SPLIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
      pragma Unreferenced(Arche, Channel);
   begin
      
      return Sequence;
   end Compose;
   function Compose (Arche : in ACID_AUDIO_IN_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
      pragma Unreferenced(Arche, Channel);
    begin
       
       return Sequence;
    end Compose;
   function Compose (Arche : in ACID_VOCODER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
      pragma Unreferenced(Arche, Channel);
    begin
       
       return Sequence;
    end Compose;
   function Compose (Arche : in ACID_USER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
      pragma Unreferenced(Arche, Channel);
    begin
   
       return Sequence;
    end Compose;
   
   function Compose (Arche : in ACID_DRUMS_KIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   
   ---------------------------------------------------------------------------
   --                                Techno                                 --
   ---------------------------------------------------------------------------
   
   function Compose (Arche : in TECHNO_BASS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin      
      
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);      
      
      return Sequence;
   end Compose;
   function Compose (Arche : in TECHNO_LEAD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TECHNO_SYNTH_HARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TECHNO_SYNTH_SOFT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TECHNO_MOTION_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TECHNO_STRINGS_N_PADS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TECHNO_KEYBOARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TECHNO_GUITARE_N_PLUCK_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TECHNO_BELL_N_DECAY_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TECHNO_HIT_N_DRUM_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bassdrum.Bassdrum_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TECHNO_S_E_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TECHNO_ARP_SEQ_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TECHNO_SPLIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
      pragma Unreferenced(Arche, Channel);
   begin
      
      return Sequence;
   end Compose;
   function Compose (Arche : in TECHNO_AUDIO_IN_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in TECHNO_VOCODER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in TECHNO_USER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
       pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in TECHNO_DRUMS_KIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   
   ---------------------------------------------------------------------------
   --                                  Minimal                              --
   ---------------------------------------------------------------------------
   
   function Compose (Arche : in MINIMAL_BASS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin      
      --Put_Line("Call Bass_Gen.respond for MINIMAL_BASS with filename : " & Arche.Filename.all);
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);            
      --Put_Line("Arche compose with Bass_Gen for MINIMAL_BASS with filename : " & Arche.Filename.all & " done.");
      return Sequence;
   end Compose;
   function Compose (Arche : in MINIMAL_LEAD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in MINIMAL_SYNTH_HARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in MINIMAL_SYNTH_SOFT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in MINIMAL_MOTION_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in MINIMAL_STRINGS_N_PADS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in MINIMAL_KEYBOARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in MINIMAL_GUITARE_N_PLUCK_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in MINIMAL_BELL_N_DECAY_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in MINIMAL_HIT_N_DRUM_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bassdrum.Bassdrum_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in MINIMAL_S_E_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in MINIMAL_ARP_SEQ_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in MINIMAL_SPLIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
      pragma Unreferenced(Arche, Channel);
   begin
      
      return Sequence;
   end Compose;
   function Compose (Arche : in MINIMAL_AUDIO_IN_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in MINIMAL_VOCODER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in MINIMAL_USER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in MINIMAL_DRUMS_KIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   

   
   ---------------------------------------------------------------------------
   --                                  Hardtech                             --
   ---------------------------------------------------------------------------
   
   function Compose (Arche : in HARDTECH_BASS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin      
      
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);      
      
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDTECH_LEAD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDTECH_SYNTH_HARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDTECH_SYNTH_SOFT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDTECH_MOTION_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDTECH_STRINGS_N_PADS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDTECH_KEYBOARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDTECH_GUITARE_N_PLUCK_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDTECH_BELL_N_DECAY_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDTECH_HIT_N_DRUM_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bassdrum.Bassdrum_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDTECH_S_E_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDTECH_ARP_SEQ_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDTECH_SPLIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
      pragma Unreferenced(Arche, Channel);
   begin
      
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDTECH_AUDIO_IN_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in HARDTECH_VOCODER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in HARDTECH_USER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in HARDTECH_DRUMS_KIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   

   
   ---------------------------------------------------------------------------
   --                                  Trance                               --
   ---------------------------------------------------------------------------
   
   
   function Compose (Arche : in TRANCE_BASS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin      
      
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);      
      
      return Sequence;
   end Compose;
   function Compose (Arche : in TRANCE_LEAD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRANCE_SYNTH_HARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRANCE_SYNTH_SOFT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRANCE_MOTION_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRANCE_STRINGS_N_PADS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRANCE_KEYBOARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRANCE_GUITARE_N_PLUCK_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRANCE_BELL_N_DECAY_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRANCE_HIT_N_DRUM_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bassdrum.Bassdrum_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRANCE_S_E_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRANCE_ARP_SEQ_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRANCE_SPLIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
      pragma Unreferenced(Arche, Channel);
   begin
      
      return Sequence;
   end Compose;
   function Compose (Arche : in TRANCE_AUDIO_IN_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in TRANCE_VOCODER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in TRANCE_USER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in TRANCE_DRUMS_KIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   

   ---------------------------------------------------------------------------
   --                                  Tribe                                --
   ---------------------------------------------------------------------------
   
   function Compose (Arche : in TRIBE_BASS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin      
      
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);      
      
      return Sequence;
   end Compose;
   function Compose (Arche : in TRIBE_LEAD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRIBE_SYNTH_HARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRIBE_SYNTH_SOFT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRIBE_MOTION_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRIBE_STRINGS_N_PADS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRIBE_KEYBOARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRIBE_GUITARE_N_PLUCK_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRIBE_BELL_N_DECAY_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRIBE_HIT_N_DRUM_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bassdrum.Bassdrum_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRIBE_S_E_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRIBE_ARP_SEQ_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in TRIBE_SPLIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
      pragma Unreferenced(Arche, Channel);
   begin
      
      return Sequence;
   end Compose;
   function Compose (Arche : in TRIBE_AUDIO_IN_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in TRIBE_VOCODER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in TRIBE_USER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in TRIBE_DRUMS_KIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   

   
   ---------------------------------------------------------------------------
   --                                   DnB                                 --
   ---------------------------------------------------------------------------
   
   
   function Compose (Arche : in DNB_BASS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin      
      
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);      
      
      return Sequence;
   end Compose;
   function Compose (Arche : in DNB_LEAD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in DNB_SYNTH_HARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in DNB_SYNTH_SOFT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in DNB_MOTION_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in DNB_STRINGS_N_PADS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in DNB_KEYBOARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in DNB_GUITARE_N_PLUCK_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in DNB_BELL_N_DECAY_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in DNB_HIT_N_DRUM_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bassdrum.Bassdrum_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in DNB_S_E_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in DNB_ARP_SEQ_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in DNB_SPLIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
      pragma Unreferenced(Arche, Channel);
   begin
      
      return Sequence;
   end Compose;
   function Compose (Arche : in DNB_AUDIO_IN_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in DNB_VOCODER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in DNB_USER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in DNB_DRUMS_KIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   

   
   ---------------------------------------------------------------------------
   --                                Hardcore                               --
   ---------------------------------------------------------------------------
   
   
   function Compose (Arche : in HARDCORE_BASS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin      
      
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);      
      
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDCORE_LEAD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDCORE_SYNTH_HARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDCORE_SYNTH_SOFT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDCORE_MOTION_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDCORE_STRINGS_N_PADS_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDCORE_KEYBOARD_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDCORE_GUITARE_N_PLUCK_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Lead.Lead_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDCORE_BELL_N_DECAY_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDCORE_HIT_N_DRUM_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bassdrum.Bassdrum_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDCORE_S_E_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDCORE_ARP_SEQ_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Bass.Bass_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDCORE_SPLIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
      pragma Unreferenced(Arche, Channel);
   begin
      
      return Sequence;
   end Compose;
   function Compose (Arche : in HARDCORE_AUDIO_IN_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in HARDCORE_VOCODER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in HARDCORE_USER_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
       Sequence : Seq_Vectors.Vector;
    pragma Unreferenced(Arche, Channel);
   begin
          return Sequence;
    end Compose;
   function Compose (Arche : in HARDCORE_DRUMS_KIT_Type; Channel : in Channel_Type)  return Seq_Vectors.Vector is
      Sequence : Seq_Vectors.Vector;
   begin
      Libsens.Data.Drums.Drums_Gen.Respond(Arche.Filename.all, Channel, Sequence);
      return Sequence;
   end Compose;
   

end Libsens.Arch;
