
-- create hierarchical project files with Project.lst file.

with Ada.Text_Io;
--use Ada.Text_Io;
with Ada.Command_Line;
use Ada.Command_Line;
with Gnat.Os_Lib;
use Gnat.Os_Lib;
with Ada.Strings.Fixed;
use Ada.Strings.Fixed;
with Ada.Wide_Text_Io;
with Ada.Strings.Wide_Fixed;
use Ada.Strings;
with Ada.Characters.Handling;
use Ada.Characters.Handling;
with Ada.Calendar.Formatting;
use Ada.Calendar;
with Ada.Unchecked_Deallocation;
use Ada;
procedure Project is
   package T_Io renames Ada.Text_Io;
   
   package W_Io renames Ada.Wide_Text_Io;
   use W_Io;
   
   
   procedure To_filename (Line : in out Wide_String) is
      Cur : Natural := 0;      
   begin
      Line(Line'First) := To_Wide_character(To_Upper(To_character(Line(Line'First))));
      loop
	 Cur := Wide_Fixed.Index(Line, "-");
	 if Cur = 0 then
	    exit;
	 end if;
	 Line(Cur) := '.';
	 Line(Cur+1) := To_Wide_Character(To_Upper(To_character(Line(Cur+1))));
      end loop;
   end To_Filename;
   
   
   Project_File : File_Type;
   Project_Name : access Wide_String;
   
   type String_Access is access all Wide_String;
   procedure String_Free is new Unchecked_Deallocation (Wide_String, String_Access);
   type String_Array is array (Positive range <>) of String_Access;
   
   type String_Set(Max_Lines : Positive) is
      record
	 Lines : String_Array(1..Max_Lines);
      end record;
   
   Max_Lines : Positive := 16384;
   Last_Index : Natural := 0;
   
   Abstract_File : File_Type;
   
   Gpl_File  : File_Type;
   
   Gpl_Set : String_Set(4096);
   Gpl_Index : Natural := 0;
   
   Prefix : constant Wide_String := "--";
   
   Version_File : File_Type;   
   Version_String : String_Access;
   
   Date : constant String := Formatting.Image(Clock);	
   Char : Character := ' ';
begin
   W_io.Put_Line("We are the " & To_Wide_String(Date));
   W_io.Open(Version_File, In_File, "Versions.lst", Form => "WCEM=8");
   while not End_Of_File(Version_File) loop
      declare
	 Line : constant Wide_String := Get_Line(Version_File);
      begin
	 String_Free(Version_String);
	 Version_String := new Wide_String ' (Line);
      end;
   end loop;
   W_io.Put_Line("The version is " & Version_String.all);
   W_io.Open(Abstract_File, In_File, "Abstract.txt", Form => "WCEM=8");	
   W_io.Put_Line("Open Abstract.txt...");	
   declare
      Abstract_Line : constant Wide_String := W_io.Get_Line(Abstract_File);
   begin
      W_io.Close(Abstract_File);
      W_Io.Open(Gpl_File, In_File, "gpl.txt", Form => "WCEM=8");	
      W_io.Put_Line("Open gtl.txt...");	
      while not End_Of_File(Gpl_File) loop
	 Gpl_Set.Lines(Gpl_Index+1) := new Wide_String  ' (W_io.Get_Line(Gpl_File));
	 Gpl_Index := Gpl_Index + 1;
      end loop;
      W_io.Close(Gpl_File);
      W_io.Put_Line("End traitment...");	
      
      if Argument_Count < 1 then
	 W_io.Put_Line("Project name requiered.");
	 return;
      else
	 Project_Name := new Wide_String ' (To_Wide_String(Argument(1)));
	 if not Is_Regular_File(To_String(Project_Name.all)) then
	    W_io.Put_Line("File name : """ & Project_Name.all & """ is not regulary file.");
	    return;
	 end if;
      end if;
      if Argument_Count > 1 then
	 begin
	    Max_Lines := Integer'Value(Argument(2));
	 exception
	    when Constraint_Error =>
	       W_io.Put_Line("Max lines is not a positive.");
	       return;
	 end;
      end if;
      Put("Enter your name : ");
      declare
	 Dir_Table, File_Table : String_Set(Max_Lines);
	 File : File_Type;
	 User_Name : access Wide_String;
	 Name_Last : Natural := 0;
      begin	     
         W_io.Open(File, In_File, "Copyright");
         declare   
	      Line : Wide_String := W_io.Get_Line(File);	
	 begin
              User_Name := new Wide_String ' (Line);	
	 end; 
	 Close(File);
	 Put("Name ok ! ! ! !  ");
	 W_Io.Open(Project_File, In_File, To_String(Project_Name.all), Form => "WCEM=8");	
       Put("open project file ");
	 while not End_Of_File(Project_File) loop
	    Dir_Table.Lines(Last_Index + 1) := new Wide_String ' (W_Io.Get_Line(Project_File));
	    Last_Index := Last_Index + 1;
	 end loop;
	 Close(Project_File);
	 
	 
	 for name in 2..Last_Index loop	 
	    File_Table.Lines(Name) := new Wide_String ' (Dir_Table.Lines(Name).all);
	 end loop;
	 for name in 2..Last_Index loop	 
	    To_Filename(File_Table.Lines(Name).all);
	 end loop;
	 if not Is_Regular_File(To_String(Dir_Table.lines(1).all) & Directory_Separator &
				  To_String(Dir_Table.lines(1).all) & 
				  Directory_Separator & "src" & 
				  Directory_Separator & To_String(Dir_Table.Lines(1).all) & ".adb") then
	    W_Io.Create(File, Out_File, To_String(Dir_Table.lines(1).all) & Directory_Separator &
			  To_String(Dir_Table.lines(1).all) & 
			  Directory_Separator & "src" & 
			  Directory_Separator & To_String(Dir_Table.Lines(1).all) & ".adb", Form=>"WCEM=8");
	    Put("Create adb file: ");
	    W_Io.Put_Line(File, Prefix & ' ' & Abstract_Line);
	    W_Io.Put_Line(File, Prefix & ' ' & File_Table.Lines(2).all & ' ' & "is Copyright (C)" & To_Wide_String(Year_Number'Image(Year(Clock))) & ' ' & User_Name.all & " ; ");
	   for Gpl_Line in 295..309 loop
	      W_Io.Put_Line(File, Prefix & Gpl_Set.Lines(Gpl_Line).all(2..Gpl_Set.Lines(Gpl_Line).all'Last));
	   end loop;
	   W_Io.Put_Line(File, Prefix & ' ' & "Date := " & """" & To_Wide_String(Date) & """");
	   W_Io.Put_Line(File, Prefix & ' ' & "Version := """ & Version_String.all  & """");
	   
	   for name in 3..Last_Index loop
	      W_Io.Put_Line(File, "with " & File_Table.Lines(Name).all & " ; ");
	   end loop;
	   
	   
	   W_Io.Put_Line(File, "procedure " & File_Table.Lines(2).all & " is");
	   W_Io.New_Line(File);
	   W_Io.Put_Line(File, "begin");
	   W_Io.New_Line(File);
	   W_Io.Put_Line(File, "   null;");
	   W_Io.Put_Line(File, "end " & File_Table.Lines(2).all & " ; ");
	   W_Io.Close(File);
	 end if;
	 for name in 3..Last_Index loop	 	 
	    if not Is_Regular_File(To_String(Dir_Table.lines(1).all) & Directory_Separator &
		     To_String(Dir_Table.lines(name).all) & 
		     Directory_Separator & "src" & 
		     Directory_Separator & "lib" & 
		     Directory_Separator &
				     To_String(Dir_Table.Lines(Name).all) & ".ads") then
	       
	       W_Io.Create(File, Out_File, To_String(Dir_Table.lines(1).all) & Directory_Separator &
			To_String(Dir_Table.lines(name).all) & 
			Directory_Separator & "src" & 
			Directory_Separator & "lib" & 
			Directory_Separator &
			To_String(Dir_Table.Lines(Name).all) & ".ads");
	       W_Io.Put_Line(File, Prefix & ' ' & Abstract_Line);
	       W_Io.Put_Line(File, Prefix & ' ' & File_Table.Lines(2).all & ' ' & "is Copyright (C)" & To_Wide_String(Year_Number'Image(Year(Clock))) & ' ' & User_Name.all & " ; ");
	       for Gpl_Line in 295..309 loop
		  W_Io.Put_Line(File, Prefix & Gpl_Set.Lines(Gpl_Line).all(2..Gpl_Set.Lines(Gpl_Line).all'Last));
	       end loop;
	       W_Io.Put_Line(File, Prefix & ' ' & "Date := " & """" & To_Wide_String(Date) & """");
	       W_Io.Put_Line(File, Prefix & ' ' & "Version := """ & Version_String.all  & """");
	       
	       
	       W_Io.Put_Line(File, "package " & File_Table.Lines(Name).all & " is");
	       W_Io.New_Line(File);
	       W_Io.Put_Line(File, "end " & File_Table.Lines(Name).all & " ; ");
	       W_Io.Close(File);
	    end if;
	 end loop;
      end;
   end;
end;
   
