pragma Warnings (Off);
pragma Ada_95;
with System;
with System.Parameters;
with System.Secondary_Stack;
package ada_main is

   gnat_argc : Integer;
   gnat_argv : System.Address;
   gnat_envp : System.Address;

   pragma Import (C, gnat_argc);
   pragma Import (C, gnat_argv);
   pragma Import (C, gnat_envp);

   gnat_exit_status : Integer;
   pragma Import (C, gnat_exit_status);

   GNAT_Version : constant String :=
                    "GNAT Version: 8.3.0" & ASCII.NUL;
   pragma Export (C, GNAT_Version, "__gnat_version");

   Ada_Main_Program_Name : constant String := "_ada_tmenu" & ASCII.NUL;
   pragma Export (C, Ada_Main_Program_Name, "__gnat_ada_main_program_name");

   procedure adainit;
   pragma Export (C, adainit, "adainit");

   procedure adafinal;
   pragma Export (C, adafinal, "adafinal");

   function main
     (argc : Integer;
      argv : System.Address;
      envp : System.Address)
      return Integer;
   pragma Export (C, main, "main");

   type Version_32 is mod 2 ** 32;
   u00001 : constant Version_32 := 16#887ac333#;
   pragma Export (C, u00001, "tmenuB");
   u00002 : constant Version_32 := 16#050ff2f0#;
   pragma Export (C, u00002, "system__standard_libraryB");
   u00003 : constant Version_32 := 16#4113f22b#;
   pragma Export (C, u00003, "system__standard_libraryS");
   u00004 : constant Version_32 := 16#76789da1#;
   pragma Export (C, u00004, "adaS");
   u00005 : constant Version_32 := 16#5b4659fa#;
   pragma Export (C, u00005, "ada__charactersS");
   u00006 : constant Version_32 := 16#8f637df8#;
   pragma Export (C, u00006, "ada__characters__handlingB");
   u00007 : constant Version_32 := 16#3b3f6154#;
   pragma Export (C, u00007, "ada__characters__handlingS");
   u00008 : constant Version_32 := 16#4b7bb96a#;
   pragma Export (C, u00008, "ada__characters__latin_1S");
   u00009 : constant Version_32 := 16#e6d4fa36#;
   pragma Export (C, u00009, "ada__stringsS");
   u00010 : constant Version_32 := 16#4635ec04#;
   pragma Export (C, u00010, "systemS");
   u00011 : constant Version_32 := 16#34742901#;
   pragma Export (C, u00011, "system__exception_tableB");
   u00012 : constant Version_32 := 16#1b9b8546#;
   pragma Export (C, u00012, "system__exception_tableS");
   u00013 : constant Version_32 := 16#ae860117#;
   pragma Export (C, u00013, "system__soft_linksB");
   u00014 : constant Version_32 := 16#bbca7dc7#;
   pragma Export (C, u00014, "system__soft_linksS");
   u00015 : constant Version_32 := 16#20d205ed#;
   pragma Export (C, u00015, "system__secondary_stackB");
   u00016 : constant Version_32 := 16#bb5d8e68#;
   pragma Export (C, u00016, "system__secondary_stackS");
   u00017 : constant Version_32 := 16#36a16434#;
   pragma Export (C, u00017, "system__parametersB");
   u00018 : constant Version_32 := 16#bea32858#;
   pragma Export (C, u00018, "system__parametersS");
   u00019 : constant Version_32 := 16#ced09590#;
   pragma Export (C, u00019, "system__storage_elementsB");
   u00020 : constant Version_32 := 16#6bf6a600#;
   pragma Export (C, u00020, "system__storage_elementsS");
   u00021 : constant Version_32 := 16#7d395b5e#;
   pragma Export (C, u00021, "system__soft_links__initializeB");
   u00022 : constant Version_32 := 16#5697fc2b#;
   pragma Export (C, u00022, "system__soft_links__initializeS");
   u00023 : constant Version_32 := 16#f52efeca#;
   pragma Export (C, u00023, "ada__exceptionsB");
   u00024 : constant Version_32 := 16#e824681c#;
   pragma Export (C, u00024, "ada__exceptionsS");
   u00025 : constant Version_32 := 16#5726abed#;
   pragma Export (C, u00025, "ada__exceptions__last_chance_handlerB");
   u00026 : constant Version_32 := 16#41e5552e#;
   pragma Export (C, u00026, "ada__exceptions__last_chance_handlerS");
   u00027 : constant Version_32 := 16#ce4af020#;
   pragma Export (C, u00027, "system__exceptionsB");
   u00028 : constant Version_32 := 16#2e5681f2#;
   pragma Export (C, u00028, "system__exceptionsS");
   u00029 : constant Version_32 := 16#80916427#;
   pragma Export (C, u00029, "system__exceptions__machineB");
   u00030 : constant Version_32 := 16#3bad9081#;
   pragma Export (C, u00030, "system__exceptions__machineS");
   u00031 : constant Version_32 := 16#aa0563fc#;
   pragma Export (C, u00031, "system__exceptions_debugB");
   u00032 : constant Version_32 := 16#38bf15c0#;
   pragma Export (C, u00032, "system__exceptions_debugS");
   u00033 : constant Version_32 := 16#6c2f8802#;
   pragma Export (C, u00033, "system__img_intB");
   u00034 : constant Version_32 := 16#44ee0cc6#;
   pragma Export (C, u00034, "system__img_intS");
   u00035 : constant Version_32 := 16#39df8c17#;
   pragma Export (C, u00035, "system__tracebackB");
   u00036 : constant Version_32 := 16#181732c0#;
   pragma Export (C, u00036, "system__tracebackS");
   u00037 : constant Version_32 := 16#9ed49525#;
   pragma Export (C, u00037, "system__traceback_entriesB");
   u00038 : constant Version_32 := 16#466e1a74#;
   pragma Export (C, u00038, "system__traceback_entriesS");
   u00039 : constant Version_32 := 16#c2486b24#;
   pragma Export (C, u00039, "system__traceback__symbolicB");
   u00040 : constant Version_32 := 16#c84061d1#;
   pragma Export (C, u00040, "system__traceback__symbolicS");
   u00041 : constant Version_32 := 16#179d7d28#;
   pragma Export (C, u00041, "ada__containersS");
   u00042 : constant Version_32 := 16#701f9d88#;
   pragma Export (C, u00042, "ada__exceptions__tracebackB");
   u00043 : constant Version_32 := 16#20245e75#;
   pragma Export (C, u00043, "ada__exceptions__tracebackS");
   u00044 : constant Version_32 := 16#5ab55268#;
   pragma Export (C, u00044, "interfacesS");
   u00045 : constant Version_32 := 16#769e25e6#;
   pragma Export (C, u00045, "interfaces__cB");
   u00046 : constant Version_32 := 16#f60287af#;
   pragma Export (C, u00046, "interfaces__cS");
   u00047 : constant Version_32 := 16#e865e681#;
   pragma Export (C, u00047, "system__bounded_stringsB");
   u00048 : constant Version_32 := 16#31c8cd1d#;
   pragma Export (C, u00048, "system__bounded_stringsS");
   u00049 : constant Version_32 := 16#b018f329#;
   pragma Export (C, u00049, "system__crtlS");
   u00050 : constant Version_32 := 16#2260731f#;
   pragma Export (C, u00050, "system__dwarf_linesB");
   u00051 : constant Version_32 := 16#5f137e60#;
   pragma Export (C, u00051, "system__dwarf_linesS");
   u00052 : constant Version_32 := 16#a0d3d22b#;
   pragma Export (C, u00052, "system__address_imageB");
   u00053 : constant Version_32 := 16#e7d9713e#;
   pragma Export (C, u00053, "system__address_imageS");
   u00054 : constant Version_32 := 16#ec78c2bf#;
   pragma Export (C, u00054, "system__img_unsB");
   u00055 : constant Version_32 := 16#ed47ac70#;
   pragma Export (C, u00055, "system__img_unsS");
   u00056 : constant Version_32 := 16#72b39087#;
   pragma Export (C, u00056, "system__unsigned_typesS");
   u00057 : constant Version_32 := 16#d7aac20c#;
   pragma Export (C, u00057, "system__ioB");
   u00058 : constant Version_32 := 16#d8771b4b#;
   pragma Export (C, u00058, "system__ioS");
   u00059 : constant Version_32 := 16#f790d1ef#;
   pragma Export (C, u00059, "system__mmapB");
   u00060 : constant Version_32 := 16#7c445363#;
   pragma Export (C, u00060, "system__mmapS");
   u00061 : constant Version_32 := 16#92d882c5#;
   pragma Export (C, u00061, "ada__io_exceptionsS");
   u00062 : constant Version_32 := 16#0cdaa54a#;
   pragma Export (C, u00062, "system__mmap__os_interfaceB");
   u00063 : constant Version_32 := 16#82f29877#;
   pragma Export (C, u00063, "system__mmap__os_interfaceS");
   u00064 : constant Version_32 := 16#834dfe5e#;
   pragma Export (C, u00064, "system__mmap__unixS");
   u00065 : constant Version_32 := 16#68267aea#;
   pragma Export (C, u00065, "system__os_libB");
   u00066 : constant Version_32 := 16#4542b55d#;
   pragma Export (C, u00066, "system__os_libS");
   u00067 : constant Version_32 := 16#d1060688#;
   pragma Export (C, u00067, "system__case_utilB");
   u00068 : constant Version_32 := 16#623c85d3#;
   pragma Export (C, u00068, "system__case_utilS");
   u00069 : constant Version_32 := 16#2a8e89ad#;
   pragma Export (C, u00069, "system__stringsB");
   u00070 : constant Version_32 := 16#2623c091#;
   pragma Export (C, u00070, "system__stringsS");
   u00071 : constant Version_32 := 16#ef6ff0b4#;
   pragma Export (C, u00071, "system__object_readerB");
   u00072 : constant Version_32 := 16#0b06497e#;
   pragma Export (C, u00072, "system__object_readerS");
   u00073 : constant Version_32 := 16#1a74a354#;
   pragma Export (C, u00073, "system__val_lliB");
   u00074 : constant Version_32 := 16#dc110aa4#;
   pragma Export (C, u00074, "system__val_lliS");
   u00075 : constant Version_32 := 16#afdbf393#;
   pragma Export (C, u00075, "system__val_lluB");
   u00076 : constant Version_32 := 16#0841c7f5#;
   pragma Export (C, u00076, "system__val_lluS");
   u00077 : constant Version_32 := 16#27b600b2#;
   pragma Export (C, u00077, "system__val_utilB");
   u00078 : constant Version_32 := 16#ea955afa#;
   pragma Export (C, u00078, "system__val_utilS");
   u00079 : constant Version_32 := 16#d7bf3f29#;
   pragma Export (C, u00079, "system__exception_tracesB");
   u00080 : constant Version_32 := 16#62eacc9e#;
   pragma Export (C, u00080, "system__exception_tracesS");
   u00081 : constant Version_32 := 16#8c33a517#;
   pragma Export (C, u00081, "system__wch_conB");
   u00082 : constant Version_32 := 16#5d48ced6#;
   pragma Export (C, u00082, "system__wch_conS");
   u00083 : constant Version_32 := 16#9721e840#;
   pragma Export (C, u00083, "system__wch_stwB");
   u00084 : constant Version_32 := 16#7059e2d7#;
   pragma Export (C, u00084, "system__wch_stwS");
   u00085 : constant Version_32 := 16#a831679c#;
   pragma Export (C, u00085, "system__wch_cnvB");
   u00086 : constant Version_32 := 16#52ff7425#;
   pragma Export (C, u00086, "system__wch_cnvS");
   u00087 : constant Version_32 := 16#ece6fdb6#;
   pragma Export (C, u00087, "system__wch_jisB");
   u00088 : constant Version_32 := 16#d28f6d04#;
   pragma Export (C, u00088, "system__wch_jisS");
   u00089 : constant Version_32 := 16#41837d1e#;
   pragma Export (C, u00089, "system__stack_checkingB");
   u00090 : constant Version_32 := 16#c88a87ec#;
   pragma Export (C, u00090, "system__stack_checkingS");
   u00091 : constant Version_32 := 16#96df1a3f#;
   pragma Export (C, u00091, "ada__strings__mapsB");
   u00092 : constant Version_32 := 16#1e526bec#;
   pragma Export (C, u00092, "ada__strings__mapsS");
   u00093 : constant Version_32 := 16#d68fb8f1#;
   pragma Export (C, u00093, "system__bit_opsB");
   u00094 : constant Version_32 := 16#0765e3a3#;
   pragma Export (C, u00094, "system__bit_opsS");
   u00095 : constant Version_32 := 16#92f05f13#;
   pragma Export (C, u00095, "ada__strings__maps__constantsS");
   u00096 : constant Version_32 := 16#9ff11e09#;
   pragma Export (C, u00096, "ada__directoriesB");
   u00097 : constant Version_32 := 16#71554425#;
   pragma Export (C, u00097, "ada__directoriesS");
   u00098 : constant Version_32 := 16#32ac7bbb#;
   pragma Export (C, u00098, "ada__calendarB");
   u00099 : constant Version_32 := 16#5b279c75#;
   pragma Export (C, u00099, "ada__calendarS");
   u00100 : constant Version_32 := 16#d083f760#;
   pragma Export (C, u00100, "system__os_primitivesB");
   u00101 : constant Version_32 := 16#ccbafd72#;
   pragma Export (C, u00101, "system__os_primitivesS");
   u00102 : constant Version_32 := 16#8f218b8f#;
   pragma Export (C, u00102, "ada__calendar__formattingB");
   u00103 : constant Version_32 := 16#67ade573#;
   pragma Export (C, u00103, "ada__calendar__formattingS");
   u00104 : constant Version_32 := 16#e3cca715#;
   pragma Export (C, u00104, "ada__calendar__time_zonesB");
   u00105 : constant Version_32 := 16#6dc27f8f#;
   pragma Export (C, u00105, "ada__calendar__time_zonesS");
   u00106 : constant Version_32 := 16#d763507a#;
   pragma Export (C, u00106, "system__val_intB");
   u00107 : constant Version_32 := 16#0e90c63b#;
   pragma Export (C, u00107, "system__val_intS");
   u00108 : constant Version_32 := 16#1d9142a4#;
   pragma Export (C, u00108, "system__val_unsB");
   u00109 : constant Version_32 := 16#621b7dbc#;
   pragma Export (C, u00109, "system__val_unsS");
   u00110 : constant Version_32 := 16#faa9a7b2#;
   pragma Export (C, u00110, "system__val_realB");
   u00111 : constant Version_32 := 16#b81c9b15#;
   pragma Export (C, u00111, "system__val_realS");
   u00112 : constant Version_32 := 16#b2a569d2#;
   pragma Export (C, u00112, "system__exn_llfB");
   u00113 : constant Version_32 := 16#fa4b57d8#;
   pragma Export (C, u00113, "system__exn_llfS");
   u00114 : constant Version_32 := 16#1b28662b#;
   pragma Export (C, u00114, "system__float_controlB");
   u00115 : constant Version_32 := 16#a6c9af38#;
   pragma Export (C, u00115, "system__float_controlS");
   u00116 : constant Version_32 := 16#16458a73#;
   pragma Export (C, u00116, "system__powten_tableS");
   u00117 : constant Version_32 := 16#ab4ad33a#;
   pragma Export (C, u00117, "ada__directories__validityB");
   u00118 : constant Version_32 := 16#d34bdf62#;
   pragma Export (C, u00118, "ada__directories__validityS");
   u00119 : constant Version_32 := 16#adb6d201#;
   pragma Export (C, u00119, "ada__strings__fixedB");
   u00120 : constant Version_32 := 16#a86b22b3#;
   pragma Export (C, u00120, "ada__strings__fixedS");
   u00121 : constant Version_32 := 16#60da0992#;
   pragma Export (C, u00121, "ada__strings__searchB");
   u00122 : constant Version_32 := 16#c1ab8667#;
   pragma Export (C, u00122, "ada__strings__searchS");
   u00123 : constant Version_32 := 16#2938d8f7#;
   pragma Export (C, u00123, "ada__strings__unboundedB");
   u00124 : constant Version_32 := 16#9fdb1809#;
   pragma Export (C, u00124, "ada__strings__unboundedS");
   u00125 : constant Version_32 := 16#d398a95f#;
   pragma Export (C, u00125, "ada__tagsB");
   u00126 : constant Version_32 := 16#12a0afb8#;
   pragma Export (C, u00126, "ada__tagsS");
   u00127 : constant Version_32 := 16#796f31f1#;
   pragma Export (C, u00127, "system__htableB");
   u00128 : constant Version_32 := 16#c2f75fee#;
   pragma Export (C, u00128, "system__htableS");
   u00129 : constant Version_32 := 16#089f5cd0#;
   pragma Export (C, u00129, "system__string_hashB");
   u00130 : constant Version_32 := 16#60a93490#;
   pragma Export (C, u00130, "system__string_hashS");
   u00131 : constant Version_32 := 16#acee74ad#;
   pragma Export (C, u00131, "system__compare_array_unsigned_8B");
   u00132 : constant Version_32 := 16#ef369d89#;
   pragma Export (C, u00132, "system__compare_array_unsigned_8S");
   u00133 : constant Version_32 := 16#a8025f3c#;
   pragma Export (C, u00133, "system__address_operationsB");
   u00134 : constant Version_32 := 16#55395237#;
   pragma Export (C, u00134, "system__address_operationsS");
   u00135 : constant Version_32 := 16#2e260032#;
   pragma Export (C, u00135, "system__storage_pools__subpoolsB");
   u00136 : constant Version_32 := 16#cc5a1856#;
   pragma Export (C, u00136, "system__storage_pools__subpoolsS");
   u00137 : constant Version_32 := 16#d96e3c40#;
   pragma Export (C, u00137, "system__finalization_mastersB");
   u00138 : constant Version_32 := 16#1dc9d5ce#;
   pragma Export (C, u00138, "system__finalization_mastersS");
   u00139 : constant Version_32 := 16#7268f812#;
   pragma Export (C, u00139, "system__img_boolB");
   u00140 : constant Version_32 := 16#b3ec9def#;
   pragma Export (C, u00140, "system__img_boolS");
   u00141 : constant Version_32 := 16#86c56e5a#;
   pragma Export (C, u00141, "ada__finalizationS");
   u00142 : constant Version_32 := 16#10558b11#;
   pragma Export (C, u00142, "ada__streamsB");
   u00143 : constant Version_32 := 16#67e31212#;
   pragma Export (C, u00143, "ada__streamsS");
   u00144 : constant Version_32 := 16#95817ed8#;
   pragma Export (C, u00144, "system__finalization_rootB");
   u00145 : constant Version_32 := 16#09c79f94#;
   pragma Export (C, u00145, "system__finalization_rootS");
   u00146 : constant Version_32 := 16#6d4d969a#;
   pragma Export (C, u00146, "system__storage_poolsB");
   u00147 : constant Version_32 := 16#65d872a9#;
   pragma Export (C, u00147, "system__storage_poolsS");
   u00148 : constant Version_32 := 16#84042202#;
   pragma Export (C, u00148, "system__storage_pools__subpools__finalizationB");
   u00149 : constant Version_32 := 16#fe2f4b3a#;
   pragma Export (C, u00149, "system__storage_pools__subpools__finalizationS");
   u00150 : constant Version_32 := 16#020a3f4d#;
   pragma Export (C, u00150, "system__atomic_countersB");
   u00151 : constant Version_32 := 16#f269c189#;
   pragma Export (C, u00151, "system__atomic_countersS");
   u00152 : constant Version_32 := 16#039168f8#;
   pragma Export (C, u00152, "system__stream_attributesB");
   u00153 : constant Version_32 := 16#8bc30a4e#;
   pragma Export (C, u00153, "system__stream_attributesS");
   u00154 : constant Version_32 := 16#4312493f#;
   pragma Export (C, u00154, "system__file_attributesS");
   u00155 : constant Version_32 := 16#389cf034#;
   pragma Export (C, u00155, "system__os_constantsS");
   u00156 : constant Version_32 := 16#6a70d424#;
   pragma Export (C, u00156, "system__file_ioB");
   u00157 : constant Version_32 := 16#e1440d61#;
   pragma Export (C, u00157, "system__file_ioS");
   u00158 : constant Version_32 := 16#73d2d764#;
   pragma Export (C, u00158, "interfaces__c_streamsB");
   u00159 : constant Version_32 := 16#b1330297#;
   pragma Export (C, u00159, "interfaces__c_streamsS");
   u00160 : constant Version_32 := 16#bbaa76ac#;
   pragma Export (C, u00160, "system__file_control_blockS");
   u00161 : constant Version_32 := 16#8e24b3c0#;
   pragma Export (C, u00161, "system__regexpB");
   u00162 : constant Version_32 := 16#65074bc8#;
   pragma Export (C, u00162, "system__regexpS");
   u00163 : constant Version_32 := 16#927a893f#;
   pragma Export (C, u00163, "ada__text_ioB");
   u00164 : constant Version_32 := 16#5194351e#;
   pragma Export (C, u00164, "ada__text_ioS");
   u00165 : constant Version_32 := 16#d4c0c09c#;
   pragma Export (C, u00165, "ada__wide_charactersS");
   u00166 : constant Version_32 := 16#88fa0f3e#;
   pragma Export (C, u00166, "ada__wide_characters__handlingB");
   u00167 : constant Version_32 := 16#65805d01#;
   pragma Export (C, u00167, "ada__wide_characters__handlingS");
   u00168 : constant Version_32 := 16#8ae438bb#;
   pragma Export (C, u00168, "ada__wide_characters__unicodeB");
   u00169 : constant Version_32 := 16#7ae4a0bf#;
   pragma Export (C, u00169, "ada__wide_characters__unicodeS");
   u00170 : constant Version_32 := 16#27ccf663#;
   pragma Export (C, u00170, "system__utf_32B");
   u00171 : constant Version_32 := 16#d8bc05c8#;
   pragma Export (C, u00171, "system__utf_32S");
   u00172 : constant Version_32 := 16#0864f341#;
   pragma Export (C, u00172, "ada__wide_text_ioB");
   u00173 : constant Version_32 := 16#3328f2dd#;
   pragma Export (C, u00173, "ada__wide_text_ioS");
   u00174 : constant Version_32 := 16#fd2ad2f1#;
   pragma Export (C, u00174, "gnatS");
   u00175 : constant Version_32 := 16#3a3a6d38#;
   pragma Export (C, u00175, "gnat__os_libS");
   u00176 : constant Version_32 := 16#e056d01a#;
   pragma Export (C, u00176, "pragmarcS");
   u00177 : constant Version_32 := 16#12e3feb2#;
   pragma Export (C, u00177, "pragmarc__ansi_tty_controlB");
   u00178 : constant Version_32 := 16#d3a97f45#;
   pragma Export (C, u00178, "pragmarc__ansi_tty_controlS");
   u00179 : constant Version_32 := 16#c65c4e8d#;
   pragma Export (C, u00179, "tS");
   u00180 : constant Version_32 := 16#935938d8#;
   pragma Export (C, u00180, "system__memoryB");
   u00181 : constant Version_32 := 16#1f488a30#;
   pragma Export (C, u00181, "system__memoryS");

   --  BEGIN ELABORATION ORDER
   --  ada%s
   --  ada.characters%s
   --  ada.characters.latin_1%s
   --  ada.wide_characters%s
   --  gnat%s
   --  interfaces%s
   --  system%s
   --  system.address_operations%s
   --  system.address_operations%b
   --  system.atomic_counters%s
   --  system.atomic_counters%b
   --  system.case_util%s
   --  system.case_util%b
   --  system.exn_llf%s
   --  system.exn_llf%b
   --  system.float_control%s
   --  system.float_control%b
   --  system.img_bool%s
   --  system.img_bool%b
   --  system.img_int%s
   --  system.img_int%b
   --  system.io%s
   --  system.io%b
   --  system.os_primitives%s
   --  system.os_primitives%b
   --  system.parameters%s
   --  system.parameters%b
   --  system.crtl%s
   --  interfaces.c_streams%s
   --  interfaces.c_streams%b
   --  system.powten_table%s
   --  system.storage_elements%s
   --  system.storage_elements%b
   --  system.stack_checking%s
   --  system.stack_checking%b
   --  system.string_hash%s
   --  system.string_hash%b
   --  system.htable%s
   --  system.htable%b
   --  system.strings%s
   --  system.strings%b
   --  system.traceback_entries%s
   --  system.traceback_entries%b
   --  system.unsigned_types%s
   --  system.img_uns%s
   --  system.img_uns%b
   --  system.utf_32%s
   --  system.utf_32%b
   --  ada.wide_characters.unicode%s
   --  ada.wide_characters.unicode%b
   --  system.wch_con%s
   --  system.wch_con%b
   --  system.wch_jis%s
   --  system.wch_jis%b
   --  system.wch_cnv%s
   --  system.wch_cnv%b
   --  system.compare_array_unsigned_8%s
   --  system.compare_array_unsigned_8%b
   --  system.traceback%s
   --  system.traceback%b
   --  system.secondary_stack%s
   --  system.standard_library%s
   --  system.exception_traces%s
   --  ada.exceptions%s
   --  system.bit_ops%s
   --  ada.characters.handling%s
   --  system.wch_stw%s
   --  system.val_util%s
   --  system.val_llu%s
   --  system.val_lli%s
   --  system.os_lib%s
   --  ada.exceptions.traceback%s
   --  ada.exceptions.traceback%b
   --  ada.exceptions.last_chance_handler%s
   --  system.soft_links%s
   --  system.soft_links.initialize%s
   --  system.soft_links.initialize%b
   --  system.soft_links%b
   --  system.secondary_stack%b
   --  system.address_image%s
   --  system.bounded_strings%s
   --  system.exception_table%s
   --  system.exception_table%b
   --  ada.io_exceptions%s
   --  ada.containers%s
   --  system.exceptions%s
   --  system.exceptions%b
   --  ada.strings%s
   --  system.exceptions_debug%s
   --  system.exceptions_debug%b
   --  system.exception_traces%b
   --  system.memory%s
   --  system.memory%b
   --  system.bit_ops%b
   --  ada.strings.maps%s
   --  ada.strings.maps.constants%s
   --  ada.characters.handling%b
   --  system.wch_stw%b
   --  system.val_util%b
   --  system.val_llu%b
   --  system.val_lli%b
   --  system.os_lib%b
   --  interfaces.c%s
   --  system.exceptions.machine%s
   --  system.exceptions.machine%b
   --  ada.exceptions.last_chance_handler%b
   --  system.address_image%b
   --  system.bounded_strings%b
   --  system.standard_library%b
   --  ada.strings.maps%b
   --  system.mmap%s
   --  interfaces.c%b
   --  system.object_reader%s
   --  system.mmap.unix%s
   --  system.mmap.os_interface%s
   --  system.mmap%b
   --  system.dwarf_lines%s
   --  system.object_reader%b
   --  system.mmap.os_interface%b
   --  system.traceback.symbolic%s
   --  system.traceback.symbolic%b
   --  ada.exceptions%b
   --  system.dwarf_lines%b
   --  ada.strings.search%s
   --  ada.strings.search%b
   --  ada.strings.fixed%s
   --  ada.strings.fixed%b
   --  ada.tags%s
   --  ada.tags%b
   --  ada.streams%s
   --  ada.streams%b
   --  ada.wide_characters.handling%s
   --  ada.wide_characters.handling%b
   --  gnat.os_lib%s
   --  system.file_control_block%s
   --  system.finalization_root%s
   --  system.finalization_root%b
   --  ada.finalization%s
   --  system.file_io%s
   --  system.file_io%b
   --  system.os_constants%s
   --  system.storage_pools%s
   --  system.storage_pools%b
   --  system.finalization_masters%s
   --  system.finalization_masters%b
   --  system.storage_pools.subpools%s
   --  system.storage_pools.subpools.finalization%s
   --  system.storage_pools.subpools%b
   --  system.storage_pools.subpools.finalization%b
   --  system.stream_attributes%s
   --  system.stream_attributes%b
   --  ada.strings.unbounded%s
   --  ada.strings.unbounded%b
   --  system.val_real%s
   --  system.val_real%b
   --  system.val_uns%s
   --  system.val_uns%b
   --  system.val_int%s
   --  system.val_int%b
   --  ada.calendar%s
   --  ada.calendar%b
   --  ada.calendar.time_zones%s
   --  ada.calendar.time_zones%b
   --  ada.calendar.formatting%s
   --  ada.calendar.formatting%b
   --  ada.text_io%s
   --  ada.text_io%b
   --  ada.wide_text_io%s
   --  ada.wide_text_io%b
   --  system.file_attributes%s
   --  system.regexp%s
   --  system.regexp%b
   --  ada.directories%s
   --  ada.directories.validity%s
   --  ada.directories.validity%b
   --  ada.directories%b
   --  pragmarc%s
   --  pragmarc.ansi_tty_control%s
   --  pragmarc.ansi_tty_control%b
   --  t%s
   --  tmenu%b
   --  END ELABORATION ORDER

end ada_main;
