--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 19:33:08 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.12.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Gnos.Parameters;
with Gnos.Systems;
generic   
   
   Params : Parameters.Neural_Parameters_Type;
   
package Gnos.Neural is
   use Parameters;
   System_Params : constant System_Parameters_Type := System_Parameters_Type(params);
   package Objects_System is new Gnos.Systems(System_Params);
   
   Neural_Params : Parameters.Neural_Parameters_Type := Params;
   use Objects_System;
   use Objects_System.Objects_system;
   use Objects_System.Objects_System.Language;
   use Objects_System.Objects_System.Language.Agnose_Projects;
   
   
   type Neural_Context_Record is new Objects_System.System_Context_record with
      record
	 Neural_Params : Parameters.Neural_Parameters_Type := Neural.Params;
      end record;
   
   procedure initialize(Neural_Context : in out Neural_Context_Record;
			Neural_Params  : in Neural_Parameters_Type);
   procedure Load_Project(Neural_Context : in out Neural_Context_Record;
			  Ada_Path : in String;
			  Gtk_Path : in String;
			  Aws_Path : in String;
			  Project_Path : in String);
   
   function Check_Parameters(Neural_Context : in Neural_Context_Record;
			     Params : in Neural_Parameters_Type) return Boolean;

   type Neural_unit_record is tagged
      record	 
	 Human_Lang : Human_Lang_Enum := Human_Lang_Enum'First;
      end record;
   type Neural_Unit_Access is access all Neural_Unit_record;
   type Neural_set_array_type is array (Human_Lang_Enum range <>) of Neural_Unit_Access;
   type Neural_set_access is access Neural_Set_array_type;
   type Neural_System is new System_record with
      record
	 Neural_Lang : Human_Lang_Enum := Human_Lang_Enum'First;
	 Neural_Set : Neural_set_access;
      end record;
   
   procedure Load_Network(Neural_Set : in out Neural_Set_Array_Type; Human_Lang : in Human_Lang_Enum);
end Gnos.Neural;
