-- Skywalker is another attempt of A. i. written with Ada.
-- Skywalker is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-11-12 09:45:23"
-- Version := "0.0.8r"

with Sky.Ansi.Console;
with Sky.Ansi.Windows;
use sky;
with Ada.Unchecked_Deallocation;

generic
   Lines : Line_Range := 67;
   Columns : Column_Range := 240;
   Style : Style_Enum := Color_And_Color;
   with package Ansi_Windows is new Sky.Ansi.Windows (<>);

package Sky.Windows is
   
   function Lines_Max return Line_Range;
   function Cols_Max return Column_Range;
   use Ansi.Console;
   use Ansi_Windows;
   
   type Window_Record is tagged
      record
	 L : Line_Range := 1;
	 C : Column_Range := 1;
	 H : Line_Range := 67;
	 W : Column_Range := 240;	 
	 Text_Color : Color_Type := Cyan;
	 Win : Window_Type;
      end record;
   
   
   
   procedure Initialize (Win : in out Window_Record; 
			 Line_Pos : in Line_Range;
			 Col_Pos : in column_Range;
			 Lines : in Line_Range; 
			 Cols : in Column_Range;
			 Color : in Color_Type;
			 Box_Color : in Color_Type);
   
   procedure Set_Color (Window : in out Window_Record; Color : Color_Type);
   
   procedure Draw_Window (Win : in Window_Record);
   
   procedure Enlight_Window (Win : in Window_Record);
   
   procedure Draw_Text (Win : in Window_Record; 
   			Line : in Line_Range;
   			Col : in Column_Range;
   			Color : in Color_Type; Text : in Wide_String);
   
   procedure Enlight_Draw_Text (Win : in Window_Record; 
   			Line : in Line_Range;
   			Col : in Column_Range;
   			Color : in Color_Type; Text : in Wide_String);
   
   --  procedure Draw_Text (Win : in Window_Record;
   --  			Line : in Line_Range;
   --  			Col : in Column_Range;
   --  			Color : in Color_Type; Text : in String);
   
   type Win_Access is access all Window_Record;
   procedure Free_Win is new Ada.Unchecked_Deallocation (Window_Record, Win_Access);


end Sky.Windows ; 
