-- Skywalker is another attempt of A. i. written with Ada.
-- Skywalker is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-11-11 15:46:50"
-- Version := "0.0.2r"

package body Sky.Strings is
   
   procedure Add_Line (Set : in out Wide_String_Set;
		       Last : in out Line_Index_Range;
		       Line : in Wide_String) is           
   begin
      Last := Set.Line_Last;
      if Last = Set.Lines'Last then
	 Wide_Free (Set.Lines ( 1 ) );
	 for Line in 1..Last - 1 loop
	    Set.Lines(Line) := Set.Lines (Line + 1);
	 end loop;
	 Set.lines(Last) := new Wide_String ' (Line);
      else
	 Set.Lines(Last+1) := new Wide_String ' (Line);
	 Last := Last + 1;
      end if;
      Set.Line_Last := Last;
   end Add_Line;
   
   
   procedure Set_Free(Set : in out Wide_String_Set) is
   begin
      for Iter in Set.Lines ' range loop
	 Wide_Free(Set.Lines(Iter));
      end loop;
      Set.Line_Last := 0;
   end Set_Free;

   

   
end Sky.Strings ; 
