-- Skywalker is another attempt of A. i. written with Ada.
-- Skywalker is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-11-16 08:24:37"
-- Version := "0.0.16r"
with Sky.Parameters;
with Sky.Options;
package Sky.Interfaces is
   type Interface_Record is tagged limited
      record
	 Kit_Options : Options.Options_Kit;
	 Kit_Parameters : Parameters.Parameters_Kit;
     end record;
   function Get_Parameter
     (From : in Interface_Record;
      Flag : in Flag_Enum)
     return Parameters.Parameter_Record;   
   
   
   procedure Parameters_Descriptions
     (From : in Interface_Record);

   procedure Initialize (Main_Interface : in out Interface_Record'Class);
   
   procedure Print_Parameters (Interf : in Interface_Record'class);
   
   function Lines_Number (Line : in Wide_String) return Positive;
   
   function Columns_Number (Line : in Wide_String) return Positive;
   
private   
   procedure Set_Parameters
     (Kit_Parameters : out Parameters.Parameters_Kit;			    
      Kit_Options : in Options.Options_Kit);
   
   function Set_Parameters_From
     
     (Filename : in Wide_String) 
     
     return access Parameters.Parameters_Kit;      

end Sky.Interfaces ; 
