--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 20:03:03 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.13.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Ada.Calendar;
use Ada;
with Gnos.Results;
use Gnos.Results;
with Gnos.Projects;
generic
   with package Projects is new Gnos.Projects (<>);
package Gnos.Versions.Environment is
   use Projects;
   function Version_Update return Integer;
   
   function Version_Reset return Integer;
   
   procedure Set_Start_Time(Date : in Calendar.Time := Calendar.Clock);
   
   -- Modified file for Specifications.
   Specifications_Filenames_Search  : Results.Spawn_Result_Type;
   
   -- Modified file for Implementations.
   Implementations_Filenames_Search : Results.Spawn_Result_Type;
   
   
   function Check_Modification_To_New_Description(Project_Context : in Projects_Context_Record) return Boolean;
   function Check_Modification_To_New_Action(Project_Context : in Projects_Context_Record) return Boolean;        
   
end Gnos.versions.Environment;
