--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 20:53:00 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.14.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
package Gnos.Options is

   
   type Optionals_Flags_Enum_Type is
     -- Options flags enumeration ;
     (
      Null_option,
      Config_Filename,
      Help,
      Version_Edition,
      Name_Length,
      Unit_Max,
      Char_Max,
      Version,
      Objects_Max,
      Self_Programming,
      Self_Executed,
      Self_Wait,
      User_Wait,
      Lang,
      With_Gtk,
      With_Ada,
      With_Aws
     );
   
   type Option_Tagged_Type (Requiered_Parameter : Boolean) is tagged
     -- Option type is tagged ; with Requiered_Parameters is Boolean ;
      record
     
         Is_Setted    : Boolean            := False;
	 -- True if occure on Command line ; Default False ;
	 
	 Optionals_Flags : Optionals_Flags_Enum_Type := Null_Option;
	 -- Flag of Option occurence ; Default Nul_Option ;
	 
	 case Requiered_Parameter is
	    -- case Requiered_Parameter is
	    when False =>	       
	    -- when False =>
	       
	       null;
	       
	       --null ;
	       
	    when True =>
	       -- when True =>
	       Value : access Wide_String;
	      
	      -- Value is image of parameter.
	      
	 end case;
	 
      end record;
   
   
   type Options_Kit_Array_Type is 
     -- Option_Kit is array ;
     array (Optionals_Flags_Enum_Type) 
     -- range Options_Flags_Enum_Type enumeration
     of access Option_Tagged_Type;
   -- of access to Option_Type ;
   
   
   Full_Line_Options_Kit : constant Options_Kit_Array_Type :=
     -- Full_Options_Kit is constant Options_Kit_Array_Type     
     (
      -- where
      Null_Option => 
     	-- Nul_Option is
     	new Option_Tagged_Type (False),
      
      Config_filename => new Option_Tagged_Type (True),
      Help => new Option_Tagged_Type (False),
      Version_Edition => new Option_Tagged_Type (False),
      Name_length => new Option_Tagged_Type (True),
      Unit_max => new Option_Tagged_Type (True),
      Char_max => new Option_Tagged_Type (True),
      Version => new Option_Tagged_Type (True),      
      Objects_max => new Option_Tagged_Type (True),
      Self_programming => new Option_Tagged_Type (True),
      Self_executed => new Option_Tagged_Type (True),
      Self_wait => new Option_Tagged_Type (True),
      User_wait => new Option_Tagged_Type (True),
      Lang => new Option_Tagged_Type (True),
      With_gtk => new Option_Tagged_Type (True),
      With_Ada => new Option_Tagged_Type (True),
      With_Aws => new Option_Tagged_Type (True)
     );     
   
   Full_File_Options_Kit : constant Options_Kit_Array_Type :=
     -- Full_Options_Kit is constant Options_Kit_Array_Type     
     (
      -- where
      Null_Option => 
     	-- Nul_Option is
     	new Option_Tagged_Type (False),
      
      Config_filename => new Option_Tagged_Type (True),
      Help => new Option_Tagged_Type (False),
      Version_Edition => new Option_Tagged_Type (False),
      Name_length => new Option_Tagged_Type (True),
      Unit_max => new Option_Tagged_Type (True),
      Char_max => new Option_Tagged_Type (True),
      Version => new Option_Tagged_Type (True),      
      Objects_max => new Option_Tagged_Type (True),
      Self_programming => new Option_Tagged_Type (True),
      Self_executed => new Option_Tagged_Type (True),
      Self_wait => new Option_Tagged_Type (True),
      User_wait => new Option_Tagged_Type (True),
      Lang => new Option_Tagged_Type (True),
      With_gtk => new Option_Tagged_Type (True),
      With_Ada => new Option_Tagged_Type (True),
      With_Aws => new Option_Tagged_Type (True)
	
     );     
   
   Default_Nul_Option : constant access Option_Tagged_Type :=
       -- Default_Nul_Option is constant access to
     new Option_Tagged_Type (False);     
   -- new Option_Tagged_Type(False);   
   
   function Get_Options_From_Command_Line
     -- To get Options_Kit_array_Type from argument in command_line ;
     
     return Options_Kit_Array_Type;
   -- return Options_Kit_Array_Type;  
   
   
   function Get_Options_From_File
     (Filename : in Wide_String)
     -- To get Options_Kit_array_Type from argument in file ;
     
     return Options_Kit_Array_Type;
   -- return Options_Kit_Array_Type;  
   
end Gnos.Options;
