--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 23:02:04 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.17.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Gnos.Parameters;
with Gnos.Machines;
with Gnos.lexical;
generic   
   Params : Parameters.Objects_Parameters_Type;
   

package Gnos.Objects is
   use Parameters;
   Machines_Params : constant Language_Parameters_Type := Language_Parameters_Type(params);
   package Language is new Gnos.Machines(Machines_Params);

   Objects_Params : Parameters.Objects_Parameters_Type := Params;
   
   use Language;
   use Language.Agnose_Projects;   

   package Name_8 is new Gnos.lexical.code_random(8);
   use Name_8;
   package Name_12 is new Gnos.lexical.code_random(12);
   use Name_12;
   package Name_16 is new Gnos.lexical.code_random(16);
   use Name_16;

   type Abstract_Object is abstract tagged null record;
   
   type Object_Access is access all Abstract_Object'Class;
   
      
   Objects_Max : Natural := Params.Objects_Max;
   
   type Object_Index_Type is new Natural range 0..Objects_Max;
   
   type Objects_Array_Type is array (Object_Index_Type range <>) of Object_Access;
   
     
   type Objects_Context_Record is new Language_Context_Record with
      record
	 Objects_Params : Parameters.Objects_Parameters_Type := Objects.Params;
	 Objects_Table  : Objects_Array_Type(1..Object_Index_Type'Last);
	 Object_Index   : Object_Index_Type := 0;
      end record;
   
   
   procedure initialize(Objects_Context : in out Objects_Context_Record;
			Objects_Params  : in Objects_Parameters_Type);
   
   procedure Load_project(Objects_Context : in out Objects_Context_Record;			
			Ada_Path : in String;
			Gtk_Path : in String;
			Aws_Path : in String;
			Project_Path : in String);
   
   function Check_Parameters(Objects_Context : in Objects_Context_Record'Class;
			    Params : in Objects_Parameters_Type'class) return Boolean;
   

   type Object_unit_record is new Language_unit_record with
      record
	 null;
      end record;
   type Object_Unit_Access is access all Language_Unit_record;
   type Objects_set_array_type is array (Positive) of Language_Unit_Access;
   type objects_set_access is access Language_Set_array_type;
   type objects_System is new Language_System with
	record
		Index : Natural := 0;
		Objects_set : Objects_set_access;
	end record;
	
end Gnos.Objects;

