--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Gnostic is Ada Generic Neural Object System Engineering.                                                                                                --
-- Gnostic (C) Copyright 2016 Manuel De Girardi.                                                                                                           --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
  
--------------------------------------------------------------------------------------------------------------------------------------------------------------
-- Date        := 2016-11-27 19:33:08 ; 
-- Description : Ada Generic Neural Object System Engineering.                                                                                              --
-- Version     := 2016.12.1a ; 
-- Authors     : Manuel De Girardi.                                                                                                                         --
--------------------------------------------------------------------------------------------------------------------------------------------------------------
with Ada.Wide_Text_Io;
with Ada.Text_Io;
use Ada;
package body Gnos.Objects is
   
   procedure initialize(Objects_Context : in out Objects_Context_Record;
			Objects_Params  : in Objects_Parameters_Type) is
   begin     
      
      Objects_Context.Objects_Params := Parameters.Objects_Parameters_Type(Objects_Params);
      
      Language.Initialize(Language_Context_Record(Objects_Context), Language_Parameters_Type(Objects_Params));
   end Initialize;
   procedure Load_project(Objects_Context : in out Objects_Context_Record;			
			Ada_Path : in String;
			Gtk_Path : in String;
			Aws_Path : in String;
			Project_Path : in String) is
   begin     
      
      
      
      Language.Load_Project(Language_Context_Record(Objects_Context), Ada_Path, Gtk_Path, Aws_Path, Project_Path);
   end Load_project;


   function Check_Parameters(Objects_Context : in Objects_Context_Record'Class;
			    Params : in Objects_Parameters_Type'class) return Boolean is
      
      Checked : Boolean := False;
      
   begin
      
      Wide_Text_Io.Put("Objects Context :");
      
      Checked := Objects_Context.Objects_Params = Objects_Parameters_Type(Params);
      if not Checked then	 
	 Text_Io.New_Line;
	 if Objects_Context.Objects_Params.Objects_Max /= Objects_Parameters_Type(Params).Objects_Max then
	    Text_Io.Put_Line("Objects_Max : " & 
			       Integer'Image(Objects_Context.Objects_Params.Objects_Max) & " /= " &
			       Integer'Image(Objects_Parameters_Type(Params).Objects_Max));
	 end if;
	 
	 raise Program_Error;
      end if;
      
      Wide_Text_Io.Put("Ok, ");
      
      Checked := Checked and Language.Check_Parameters(Language_Context_Record(Objects_Context), Params);
      
      return Checked;
   end Check_Parameters;
end Gnos.Objects;
