----------------------------------------------------
-- Gmface is General MIDI attempt to interfacing. --
-- Copyright (C) 2018 Manuel De Girardi           --
----------------------------------------------------
--         gggg       mm              mm          --
--       ggg  ggg     mmmm          mmmm          --
--     gg             mm  mm      mm  mm          --
--    gg    ggggggg   mm    mm  mm    mm          --
--     gg     gg      mm      mm      mm          --
--      ggg   gg      mm              mm          --
--         gggg       mm              mm   face   --
--                                                --
----------------------------------------------------
-- Date        : Wed Feb  7 22:50:13 CET 2018     --
-- Version     : 0.1.6gnu_src                     --
-- Authors     : E. Sens                          --
-- Description : General MIDI interface           --
----------------------------------------------------
-- History :                                      --
--           This version is the full implementation
-- of Gmface interface without export capabilities.
----------------------------------------------------
-- License :                                      --
--                                                  ---------------------------
-- This program is free software; you can redistribute it and/or modify      --
-- it under the terms of the GNU General Public License as published by      --
-- the Free Software Foundation; either version 2 of the License, or         --
-- (at your option) any later version.                                       --
                                                                               
-- This program is distributed in the hope that it will be useful,           --
-- but WITHOUT ANY WARRANTY; without even the implied warranty of            --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             --
-- GNU General Public License for more details.                              --
                                                                               
-- You should have received a copy of the GNU General Public License         --
-- along with this program; if not, write to the Free Software               --
-- Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA --
-------------------------------------------------------------------------------
with Gmface.Gm_Application;
use Gmface.Gm_Application;
with Gmface.Gm_Application.Gtk_Interface;
use Gmface.Gm_Application.Gtk_Interface;
with Gmface.Gm_Virtual;
use Gmface.Gm_Virtual;
with Gmface.Gm_Virtual.Gmface.Gmface_Work;
use Gmface.Gm_Virtual.Gmface.Gmface_Work;
with Gmface.Gm_Virtual.Gmidi.Gmidi_Work;
use Gmface.Gm_Virtual.Gmidi.Gmidi_Work;

with Gmface.Gm_Case;
use Gmface.Gm_Case;

with Gnat.Command_Line;
use Gnat.Command_Line;

with Text_Io;
use Text_Io;
procedure Gmfacemain is
   
   Gtk_Interface : Gtk_Interface_Pointer;
   
   Gm_Works : aliased Work_Array;
   
   Auto_Play : Boolean := False;
   In_Loop   : Boolean := False;
   
   Work_Id   : Natural := 0;
begin
   
   begin
      
      loop
	 case Getopt ("i a l v h") is
	    -- Accept :=
	    -- h help ;
	    -- a auto play ;
	    -- l in loop ;
	    when ASCII.NUL =>
	       exit;	       	       
	    when 'a' =>
	       if Full_Switch = "a" then
		  Put_Line ("Got auto play");
		  Auto_Play := True;
	       end if;
	    when 'l' =>
	       if Full_Switch = "l" then
		  In_Loop := True;
		  Put_Line ("Got in loop");
	       end if;
	    when 'h' => 
	       if Full_Switch = "h" then		  
		  Put_Line ("Got help");
		  Put_Line("ultrason : usage : ultarson [ -a ] [ -l ] [ -h ] [Filename(s)...]");
		  return;
	       end if;	       
	    when others =>
	       raise Program_Error; -- cannot occur
	 end case;
      end loop;
            	 
      begin
	 
	 loop
	    declare
	       S : constant String := Get_Argument (Do_Expansion => True);
	    begin	 
	       
	       exit when S'Length = 0;
	       case Filetype(S) is
		  when Gmface.Gmidi_Work =>
		     null;
		  when Gmface.Gmface_Work =>
		     
		     Put_Line ("Adding Gmface work for " & S);
		     
		     Gm_Works(Work_Num(Work_Id+1)) := new Gmface_Work_Record;
		     
		     Gmface_Work_Record(Gm_Works(Work_Num(Work_Id+1)).all).Initialize
		       (Work_Num(Work_Id+1), S);
		     
		     Work_Id := Work_Id + 1;
	       end case;
	    end;   
	 end loop;
	 
      end;
   exception
      when Invalid_Switch    => Put_Line ("Invalid Switch " & Full_Switch);
	 raise;
      when Invalid_Parameter => Put_Line ("No parameter for " & Full_Switch);
	 raise;
   end;
   
   
   if Work_Id = 0 then
      Gm_Works(Work_Num(Work_Id+1)) := new Gmface_Work_Record;
      Gmface_Work_Record(Gm_Works(Work_Num(Work_Id+1)).all).Initialize(Work_Num(Work_Id+1), "");      
      Work_Id := Work_Id + 1;     
   end if;
         

   Gtk_New(Gtk_Interface, Gm_Works'access, Auto_Play, In_loop);
end Gmfacemain;
