
with Gmface.Gm_Common;                    use Gmface.Gm_Common;
with Gmface.Gm_MIDI.Instruments;          use Gmface.Gm_MIDI.Instruments;
with Gmface.Gm_Virtual;                   use Gmface.Gm_Virtual;

with Gmface.Gm_Processing.Gm_Common;      use Gmface.Gm_Processing.Gm_Common;

with Ada.Calendar;                      use Ada.Calendar;
with Interfaces.C;                      use Interfaces.C;
package Gmface.Gm_Processing.Gm_Plugins is
   
   type Gm_Plugin_Processing;
   task type Event_Process_Type(Driver : access Gm_Plugin_Processing) is
      
      entry Receive (Device  : in Device_Num;
		     Date    : in Time;
		     Message : in Interfaces.C.Long;
		     Hour    : in Duration;
		     Tempo   : in Tempo_Type);
      entry Halt;
      
   end Event_Process_Type;
   
   type Gm_Plugin_Processing is abstract tagged limited
      record
	 Box           : access Messages_Box;
	 Instruments   : access Bandmaster_Record;
	 Event_Process : Event_Process_Type(Gm_Plugin_Processing'Access);
      end record;
   
   procedure Initialize(Plugin_Process : in Gm_Plugin_Processing; Options : in Work_Options_access) is abstract;
   procedure Start(Plugin_Process : in Gm_Plugin_Processing; Start_Time : in Time; Tempo : in Tempo_Type; Signature : in Time_Signature_Type) is abstract;
   procedure Stop(Plugin_Process : in Gm_Plugin_Processing) is abstract;
   procedure Halt(Plugin_Process : in Gm_Plugin_Processing) is abstract;
end Gmface.Gm_Processing.Gm_Plugins;
