with Gmface.Gm_Common;                    use Gmface.Gm_Common;

with Ada.Unchecked_Deallocation;
package Gmface.Gm_Processing.Gm_Common is
   type Printed_Message_Type is
      record
	 Source      : String_Access;
	 Destination : String_Access;
	 Data_Type   : String_Access;
	 Channel     : String_Access;
	 Data1       : String_Access;
	 Data2       : String_Access;
	 Hour        : String_Access;
	 Hexa_Sum    : String_Access;
	 Long_Sum    : String_Access;
      end record;
   
   type Printed_Message_Access is access Printed_Message_Type;
   
   procedure Free is new Ada.Unchecked_Deallocation(Printed_Message_Type, Printed_Message_Access);
   
   subtype Printed_Message_Index_Type is Positive;

   
   task type Messages_Box is
      entry Receive(Message : in Printed_Message_Access);
      entry Send(Message : out Printed_Message_Access);
      entry Halt;
   end Messages_Box;

end Gmface.Gm_Processing.Gm_Common;
