-- aish is another attempt of A. i. written with Ada.
-- Aish is Copyright (C) 2024 Manuel De Girardi ; 
--
--   This program is free software; you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation; either version 2 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program; if not, write to the Free Software
--   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
--
-- Date := "2024-04-29 20:25:34"
-- Version := "1.1.0r"
package Ai.Parameters is
   type Parameter_Record (Requiered_Parameter : Boolean) is tagged
      record	 
	 Switch   : access Wide_String;	 	 
	 Num_Iter : Natural := 0;	 	 
	 Is_Setted : Boolean := False;	 
	 Parameter_Flag : Flag_Enum := None;	 
	 Descr : access Wide_String;	 
	 case Requiered_Parameter is
	    when False =>
	       null;
	    when True =>
	       
	       param : access Wide_String;
	       Value : access Wide_String;
	 end case;
      end record;
      
   type Parameters_Kit is 
     array (Flag_Enum) of 
     access Parameter_Record;
               
   Line_Parameters : constant Parameters_Kit := 
     (
      
      None => null,
      Config_Filename => new Parameter_Record ' 
	(Requiered_Parameter => True, Switch => new Wide_String ' ("F"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Config_Filename, 
	 Descr => new Wide_String ' ("Configuration filename"),
	 Param => new Wide_String ' ("Wide_String"),
	 Value => null),
      
      Help => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("h"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => help, 
	 Descr => new Wide_String ' ("print this message")),
      
      Version => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("v"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Version, 
	 Descr => new Wide_String ' ("print the version")),
      Term_Name => new Parameter_Record '
      	(Requiered_Parameter => True, Switch => new Wide_String ' ("N"), Num_Iter => 0,
      	 Is_Setted => False, Parameter_Flag => Term_Name, 
      	 Descr => new Wide_String ' ("Terminal name"),
      	 Param => new Wide_String ' ("String"),
      	 Value => null),
      Initialize => new Parameter_Record '	
	(Requiered_Parameter => True, Switch => new Wide_String ' ("i"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Initialize, 
	 Descr => new Wide_String ' ("initiaize total value"),
	 Param => new Wide_String ' ("fixed from -999999.99 to 999999.99"),
	 Value => null),
      Add => new Parameter_Record '	
	(Requiered_Parameter => True, Switch => new Wide_String ' ("a"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Add, 
	 Descr => new Wide_String ' ("Adding value to total"),
	 Param => new Wide_String ' ("fixed from -999999.99 to 999999.99"),
	 Value => null),
      Remove => new Parameter_Record '	
	(Requiered_Parameter => True, Switch => new Wide_String ' ("r"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Remove, 
	 Descr => new Wide_String ' ("Remove value from total"),
	 Param => new Wide_String ' ("fixed from -999999.99 to 999999.99"),
	 Value => null),
      Total => new Parameter_Record '
	(Requiered_Parameter => False, Switch => new Wide_String ' ("t"), Num_Iter => 0,
	 Is_Setted => False, Parameter_Flag => Total, 
	 Descr => new Wide_String ' ("print fixed from -999999.99 to 999999.99"))
     );
   

   File_Parameters : constant Parameters_Kit := 
	(
      
      None => null,
	 Config_Filename => new Parameter_Record ' 
	   (Requiered_Parameter => True, Switch => new Wide_String ' ("F"), Num_Iter => 0,
	    Is_Setted => False, Parameter_Flag => Config_Filename, 
	    Descr => new Wide_String ' ("Configuration filename"),
	    Param => new Wide_String ' ("Wide_String"),
	    Value => null),
	 
	 Help => new Parameter_Record '
	   (Requiered_Parameter => False, Switch => new Wide_String ' ("h"), Num_Iter => 0,
	    Is_Setted => False, Parameter_Flag => help, 
	    Descr => new Wide_String ' ("print this message")),
	 
	 Version => new Parameter_Record '
	   (Requiered_Parameter => False, Switch => new Wide_String ' ("v"), Num_Iter => 0,
	    Is_Setted => False, Parameter_Flag => Version, 
	    Descr => new Wide_String ' ("print the version")),
	 
	 Term_Name => new Parameter_Record '
	   (Requiered_Parameter => True, Switch => new Wide_String ' ("N"), Num_Iter => 0,
	    Is_Setted => False, Parameter_Flag => Term_Name, 
	    Descr => new Wide_String ' ("Terminal name"),
	    Param => new Wide_String ' ("String"),
	    Value => null),
	 Initialize => new Parameter_Record '	
	   (Requiered_Parameter => True, Switch => new Wide_String ' ("i"), Num_Iter => 0,
	    Is_Setted => False, Parameter_Flag => Initialize, 
	    Descr => new Wide_String ' ("initiaize total value"),
	    Param => new Wide_String ' ("fixed from -999999.99 to 999999.99"),
	    Value => null),
	 Add => new Parameter_Record '	
	   (Requiered_Parameter => True, Switch => new Wide_String ' ("a"), Num_Iter => 0,
	    Is_Setted => False, Parameter_Flag => Add, 
	    Descr => new Wide_String ' ("Adding value to total"),
	    Param => new Wide_String ' ("fixed from -999999.99 to 999999.99"),
	    Value => null),
	 Remove => new Parameter_Record '	
	   (Requiered_Parameter => True, Switch => new Wide_String ' ("r"), Num_Iter => 0,
	    Is_Setted => False, Parameter_Flag => Remove, 
	    Descr => new Wide_String ' ("Remove value from total"),
	    Param => new Wide_String ' ("fixed from -999999.99 to 999999.99"),
	    Value => null),
	 Total => new Parameter_Record '
	   (Requiered_Parameter => False, Switch => new Wide_String ' ("t"), Num_Iter => 0,
	    Is_Setted => False, Parameter_Flag => Total, 
	    Descr => new Wide_String ' ("print fixed from -999999.99 to 999999.99"))
	);
   
end Ai.Parameters ; 
